/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client;

import java.util.Objects;

public class ReconnectLocation {
    private final String host;
    private final int port;

    public ReconnectLocation(String host, int port) {
        Objects.requireNonNull(host, "Cannot create a reconnect entry with a null host value");
        if (host.isBlank()) {
            throw new IllegalArgumentException("Cannot create a reconnect entry with a blank host value");
        }
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReconnectLocation)) {
            return false;
        }
        ReconnectLocation other = (ReconnectLocation)obj;
        if (this.host == null ? other.host != null : !this.host.equalsIgnoreCase(other.host)) {
            return false;
        }
        return this.port == other.port;
    }
}

