/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea;

import com.alipay.sofa.jraft.Lifecycle;
import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.RaftGroupService;
import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.StateMachine;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.rhea.StoreEngine;
import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.options.RegionEngineOptions;
import com.alipay.sofa.jraft.rhea.storage.BatchRawKVStore;
import com.alipay.sofa.jraft.rhea.storage.KVStoreStateMachine;
import com.alipay.sofa.jraft.rhea.storage.MetricsRawKVStore;
import com.alipay.sofa.jraft.rhea.storage.RaftRawKVStore;
import com.alipay.sofa.jraft.rhea.util.Strings;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.util.Describer;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.internal.ThrowUtil;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Slf4jReporter;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionEngine
implements Lifecycle<RegionEngineOptions>,
Describer {
    private static final Logger LOG = LoggerFactory.getLogger(RegionEngine.class);
    private final Region region;
    private final StoreEngine storeEngine;
    private RaftRawKVStore raftRawKVStore;
    private MetricsRawKVStore metricsRawKVStore;
    private RaftGroupService raftGroupService;
    private Node node;
    private KVStoreStateMachine fsm;
    private RegionEngineOptions regionOpts;
    private ScheduledReporter regionMetricsReporter;
    private boolean started;

    public RegionEngine(Region region, StoreEngine storeEngine) {
        this.region = region;
        this.storeEngine = storeEngine;
    }

    public synchronized boolean init(RegionEngineOptions opts) {
        Configuration initialConf;
        long metricsReportPeriod;
        if (this.started) {
            LOG.info("[RegionEngine: {}] already started.", (Object)this.region);
            return true;
        }
        this.regionOpts = (RegionEngineOptions)Requires.requireNonNull((Object)opts, (String)"opts");
        this.fsm = new KVStoreStateMachine(this.region, this.storeEngine);
        NodeOptions nodeOpts = opts.getNodeOptions();
        if (nodeOpts == null) {
            nodeOpts = new NodeOptions();
        }
        if ((metricsReportPeriod = opts.getMetricsReportPeriod()) > 0L) {
            nodeOpts.setEnableMetrics(true);
        }
        if (!(initialConf = new Configuration()).parse(opts.getInitialServerList())) {
            LOG.error("Fail to parse initial configuration {}.", (Object)opts.getInitialServerList());
            return false;
        }
        nodeOpts.setInitialConf(initialConf);
        nodeOpts.setFsm((StateMachine)this.fsm);
        String raftDataPath = opts.getRaftDataPath();
        try {
            FileUtils.forceMkdir((File)new File(raftDataPath));
        }
        catch (Throwable t) {
            LOG.error("Fail to make dir for raftDataPath {}.", (Object)raftDataPath);
            return false;
        }
        if (Strings.isBlank(nodeOpts.getLogUri())) {
            Path logUri = Paths.get(raftDataPath, "log");
            nodeOpts.setLogUri(logUri.toString());
        }
        if (Strings.isBlank(nodeOpts.getRaftMetaUri())) {
            Path meteUri = Paths.get(raftDataPath, "meta");
            nodeOpts.setRaftMetaUri(meteUri.toString());
        }
        if (Strings.isBlank(nodeOpts.getSnapshotUri())) {
            Path snapshotUri = Paths.get(raftDataPath, "snapshot");
            nodeOpts.setSnapshotUri(snapshotUri.toString());
        }
        LOG.info("[RegionEngine: {}], log uri: {}, raft meta uri: {}, snapshot uri: {}.", new Object[]{this.region, nodeOpts.getLogUri(), nodeOpts.getRaftMetaUri(), nodeOpts.getSnapshotUri()});
        Endpoint serverAddress = opts.getServerAddress();
        PeerId serverId = new PeerId(serverAddress, 0);
        RpcServer rpcServer = this.storeEngine.getRpcServer();
        this.raftGroupService = new RaftGroupService(opts.getRaftGroupId(), serverId, nodeOpts, rpcServer, true);
        this.node = this.raftGroupService.start(false);
        RouteTable.getInstance().updateConfiguration(this.raftGroupService.getGroupId(), nodeOpts.getInitialConf());
        if (this.node != null) {
            MetricRegistry metricRegistry;
            BatchRawKVStore<?> rawKVStore = this.storeEngine.getRawKVStore();
            ExecutorService readIndexExecutor = this.storeEngine.getReadIndexExecutor();
            this.raftRawKVStore = new RaftRawKVStore(this.node, rawKVStore, readIndexExecutor);
            this.metricsRawKVStore = new MetricsRawKVStore(this.region.getId(), this.raftRawKVStore);
            if (this.regionMetricsReporter == null && metricsReportPeriod > 0L && (metricRegistry = this.node.getNodeMetrics().getMetricRegistry()) != null) {
                ScheduledExecutorService scheduler = this.storeEngine.getMetricsScheduler();
                this.regionMetricsReporter = Slf4jReporter.forRegistry((MetricRegistry)metricRegistry).prefixedWith("region_" + this.region.getId()).withLoggingLevel(Slf4jReporter.LoggingLevel.INFO).outputTo(LOG).scheduleOn(scheduler).shutdownExecutorOnStop(scheduler != null).build();
                this.regionMetricsReporter.start(metricsReportPeriod, TimeUnit.SECONDS);
            }
            this.started = true;
            LOG.info("[RegionEngine] start successfully: {}.", (Object)this);
        }
        return this.started;
    }

    public synchronized void shutdown() {
        if (!this.started) {
            return;
        }
        if (this.raftGroupService != null) {
            this.raftGroupService.shutdown();
            try {
                this.raftGroupService.join();
            }
            catch (InterruptedException e) {
                ThrowUtil.throwException((Throwable)e);
            }
        }
        if (this.regionMetricsReporter != null) {
            this.regionMetricsReporter.stop();
        }
        this.started = false;
        LOG.info("[RegionEngine] shutdown successfully: {}.", (Object)this);
    }

    public boolean transferLeadershipTo(Endpoint endpoint) {
        PeerId peerId = new PeerId(endpoint, 0);
        Status status = this.node.transferLeadershipTo(peerId);
        boolean isOk = status.isOk();
        if (isOk) {
            LOG.info("Transfer-leadership succeeded: [{} --> {}].", (Object)this.storeEngine.getSelfEndpoint(), (Object)endpoint);
        } else {
            LOG.error("Transfer-leadership failed: {}, [{} --> {}].", new Object[]{status, this.storeEngine.getSelfEndpoint(), endpoint});
        }
        return isOk;
    }

    public Region getRegion() {
        return this.region;
    }

    public StoreEngine getStoreEngine() {
        return this.storeEngine;
    }

    public boolean isLeader() {
        return this.node.isLeader(false);
    }

    public PeerId getLeaderId() {
        return this.node.getLeaderId();
    }

    public RaftRawKVStore getRaftRawKVStore() {
        return this.raftRawKVStore;
    }

    public MetricsRawKVStore getMetricsRawKVStore() {
        return this.metricsRawKVStore;
    }

    public Node getNode() {
        return this.node;
    }

    public KVStoreStateMachine getFsm() {
        return this.fsm;
    }

    public RegionEngineOptions copyRegionOpts() {
        return ((RegionEngineOptions)Requires.requireNonNull((Object)this.regionOpts, (String)"opts")).copy();
    }

    public String toString() {
        return "RegionEngine{region=" + this.region + ", isLeader=" + this.isLeader() + ", regionOpts=" + this.regionOpts + '}';
    }

    public void describe(Describer.Printer out) {
        out.print((Object)"  RegionEngine: ").print((Object)"regionId=").print((Object)this.region.getId()).print((Object)", isLeader=").print((Object)this.isLeader()).print((Object)", leaderId=").println((Object)this.getLeaderId());
    }
}

