/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.meta.raft.rpc;

import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.closure.ReadIndexClosure;
import com.alipay.sofa.jraft.rpc.RpcContext;
import com.alipay.sofa.jraft.util.BytesUtil;
import com.google.protobuf.Message;
import java.util.Objects;
import org.apache.rocketmq.mqtt.common.model.consistency.ReadRequest;
import org.apache.rocketmq.mqtt.common.model.consistency.Response;
import org.apache.rocketmq.mqtt.meta.raft.FailoverClosure;
import org.apache.rocketmq.mqtt.meta.raft.MqttRaftServer;
import org.apache.rocketmq.mqtt.meta.raft.processor.StateProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRpcProcessor.class);

    protected void handleRequest(MqttRaftServer server, String group, RpcContext rpcCtx, Message message) {
        try {
            Node node = server.getNode(group);
            if (Objects.isNull(node)) {
                rpcCtx.sendResponse((Object)Response.newBuilder().setSuccess(false).setErrMsg("Could not find the corresponding Raft Group : " + group).build());
                return;
            }
            if (node.isLeader()) {
                server.applyOperation(node, message, this.getFailoverClosure(rpcCtx));
            } else {
                rpcCtx.sendResponse((Object)Response.newBuilder().setSuccess(false).setErrMsg("Could not find leader : " + group).build());
            }
        }
        catch (Throwable e) {
            LOGGER.error("handleRequest has error : ", e);
            rpcCtx.sendResponse((Object)Response.newBuilder().setSuccess(false).setErrMsg(e.toString()).build());
        }
    }

    public FailoverClosure getFailoverClosure(final RpcContext rpcCtx) {
        FailoverClosure closure = new FailoverClosure(){
            Response data;
            Throwable ex;

            @Override
            public void setResponse(Response data) {
                this.data = data;
            }

            @Override
            public void setThrowable(Throwable throwable) {
                this.ex = throwable;
            }

            public void run(Status status) {
                if (Objects.nonNull(this.ex)) {
                    LOGGER.error("execute has error : ", this.ex);
                    rpcCtx.sendResponse((Object)Response.newBuilder().setErrMsg(this.ex.toString()).setSuccess(false).build());
                } else {
                    rpcCtx.sendResponse((Object)this.data);
                }
            }
        };
        return closure;
    }

    public void handleReadIndex(final MqttRaftServer server, final String group, final RpcContext rpcCtx, final ReadRequest request) {
        try {
            Node node = server.getNode(group);
            if (Objects.isNull(node)) {
                rpcCtx.sendResponse((Object)Response.newBuilder().setSuccess(false).setErrMsg("Could not find the corresponding Raft Group : " + group).build());
                return;
            }
            final StateProcessor processor = server.getProcessor(request.getCategory());
            if (Objects.isNull(processor)) {
                rpcCtx.sendResponse((Object)Response.newBuilder().setSuccess(false).setErrMsg("Could not find the StateProcessor: " + group).build());
                return;
            }
            try {
                node.readIndex(BytesUtil.EMPTY_BYTES, new ReadIndexClosure(){

                    public void run(Status status, long index, byte[] reqCtx) {
                        if (status.isOk()) {
                            try {
                                Response response = processor.onReadRequest(request);
                                rpcCtx.sendResponse((Object)response);
                            }
                            catch (Throwable t) {
                                LOGGER.info("process read request in handleReadIndex error : {}", (Object)t.toString());
                                rpcCtx.sendResponse((Object)Response.newBuilder().setErrMsg(t.toString()).setSuccess(false).build());
                            }
                            return;
                        }
                        LOGGER.error("ReadIndex has error : {}, go to Leader read.", (Object)status.getErrorMsg());
                        AbstractRpcProcessor.this.readFromLeader(server, group, rpcCtx, request);
                    }
                });
            }
            catch (Throwable e) {
                LOGGER.error("ReadIndex has error : {}, go to Leader read.", (Object)e.toString());
                this.readFromLeader(server, group, rpcCtx, request);
            }
        }
        catch (Throwable e) {
            LOGGER.error("handleReadIndex has error : ", e);
            rpcCtx.sendResponse((Object)Response.newBuilder().setSuccess(false).setErrMsg(e.toString()).build());
        }
    }

    public void readFromLeader(MqttRaftServer server, String group, RpcContext rpcCtx, ReadRequest request) {
        Node node;
        try {
            node = server.getNode(group);
            if (Objects.isNull(node)) {
                throw new Exception("can not get raft group");
            }
        }
        catch (Exception e) {
            rpcCtx.sendResponse((Object)Response.newBuilder().setSuccess(false).setErrMsg("Could not find the corresponding Raft Group : " + group).build());
            return;
        }
        if (node.isLeader()) {
            server.applyOperation(node, (Message)request, this.getFailoverClosure(rpcCtx));
        } else {
            server.invokeToLeader(group, (Message)request, 5000, this.getFailoverClosure(rpcCtx));
        }
    }
}

