/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.starter;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.mqtt.cs.config.ConnectConf;
import org.apache.rocketmq.mqtt.cs.protocol.rpc.RpcPacketDispatcher;
import org.apache.rocketmq.remoting.netty.NettyRemotingServer;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RpcServer {
    private static Logger logger = LoggerFactory.getLogger(RpcServer.class);
    @Resource
    private ConnectConf connectConf;
    @Resource
    private RpcPacketDispatcher rpcPacketDispatcher;
    private NettyRemotingServer remotingServer;
    private BlockingQueue<Runnable> csBridgeRpcQueue;

    @PostConstruct
    public void start() {
        NettyServerConfig nettyServerConfig = new NettyServerConfig();
        nettyServerConfig.setListenPort(this.connectConf.getRpcListenPort());
        this.remotingServer = new NettyRemotingServer(nettyServerConfig);
        this.csBridgeRpcQueue = new LinkedBlockingQueue<Runnable>(10000);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(8, 16, 1L, TimeUnit.MINUTES, this.csBridgeRpcQueue, (ThreadFactory)new ThreadFactoryImpl("Rpc_Server_Thread_"));
        this.remotingServer.registerDefaultProcessor((NettyRequestProcessor)this.rpcPacketDispatcher, (ExecutorService)executor);
        this.remotingServer.start();
        logger.warn("start  rpc server , port:{}", (Object)this.connectConf.getRpcListenPort());
    }
}

