/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.sphere;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class Haversine {
    public static final double AVG_EARTH_RADIUS = 6371008.0;

    public static double distance(Geometry geom1, Geometry geom2, double avg_earth_radius) {
        Coordinate coordinate1 = geom1.getGeometryType().equals("Point") ? geom1.getCoordinate() : geom1.getCentroid().getCoordinate();
        Coordinate coordinate2 = geom2.getGeometryType().equals("Point") ? geom2.getCoordinate() : geom2.getCentroid().getCoordinate();
        double lon1 = coordinate1.getX();
        double lat1 = coordinate1.getY();
        double lon2 = coordinate2.getX();
        double lat2 = coordinate2.getY();
        double latDistance = Math.toRadians(lat2 - lat1);
        double lngDistance = Math.toRadians(lon2 - lon1);
        double a = Math.sin(latDistance / 2.0) * Math.sin(latDistance / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(lngDistance / 2.0) * Math.sin(lngDistance / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return avg_earth_radius * c * 1.0;
    }

    public static double distance(Geometry geom1, Geometry geom2) {
        return Haversine.distance(geom1, geom2, 6371008.0);
    }

    public static Envelope expandEnvelope(Envelope envelope, double distance, double sphereRadius) {
        double scaleFactor = 1.1;
        double latDeltaRadian = distance / sphereRadius;
        double latDeltaDegree = Math.toDegrees(latDeltaRadian);
        double newMinY = envelope.getMinY() - latDeltaDegree * scaleFactor;
        double newMaxY = envelope.getMaxY() + latDeltaDegree * scaleFactor;
        if (newMinY <= -90.0 || newMaxY >= 90.0) {
            return new Envelope(-180.0, 180.0, Math.max(newMinY, -90.0), Math.min(newMaxY, 90.0));
        }
        double minLatRadian = Math.toRadians(newMinY);
        double maxLatRadian = Math.toRadians(newMaxY);
        double lonDeltaRadian = Math.max(Math.abs(distance / (sphereRadius * Math.cos(maxLatRadian))), Math.abs(distance / (sphereRadius * Math.cos(minLatRadian))));
        double lonDeltaDegree = Math.toDegrees(lonDeltaRadian);
        double newMinX = envelope.getMinX() - lonDeltaDegree * scaleFactor;
        double newMaxX = envelope.getMaxX() + lonDeltaDegree * scaleFactor;
        if (newMinX <= -180.0 || newMaxX >= 180.0) {
            return new Envelope(-180.0, 180.0, newMinY, newMaxY);
        }
        return new Envelope(newMinX, newMaxX, newMinY, newMaxY);
    }
}

