/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sedona.shaded.guava.collect.Lists;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft2.coverage.CoordAxisHelper;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.Time2DCoordSys;
import ucar.nc2.ft2.coverage.TimeOffsetAxis;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.Optional;

public class Time2DOffsetCoordSys
extends Time2DCoordSys {
    public final TimeOffsetAxis timeOffset;

    public Time2DOffsetCoordSys(CoverageCoordAxis1D runAxis, TimeOffsetAxis timeOffset) {
        super(runAxis, null);
        this.timeOffset = timeOffset;
    }

    @Override
    public int[] getShape() {
        if (this.runAxis.isScalar()) {
            return new int[]{this.timeOffset.getNcoords()};
        }
        return new int[]{this.runAxis.getNcoords(), this.timeOffset.getNcoords()};
    }

    @Override
    public Optional<List<CoverageCoordAxis>> subset(SubsetParams params, AtomicBoolean isConstantForcast, boolean makeCFcompliant) {
        ArrayList<CoverageCoordAxis> result = new ArrayList<CoverageCoordAxis>();
        Optional<CoverageCoordAxis> axiso = this.runAxis.subset(params);
        if (!axiso.isPresent()) {
            return Optional.empty(axiso.getErrorMessage());
        }
        CoverageCoordAxis1D runAxisSubset = (CoverageCoordAxis1D)axiso.get();
        result.add(runAxisSubset);
        if (params.hasTimeOffsetParam() || !params.hasTimeParam()) {
            axiso = this.timeOffset.subset(params);
            if (!axiso.isPresent()) {
                return Optional.empty(axiso.getErrorMessage());
            }
            CoverageCoordAxis timeOffsetSubset = axiso.get();
            result.add(timeOffsetSubset);
            if (makeCFcompliant) {
                result.add(this.makeCFTimeCoord(runAxisSubset, (CoverageCoordAxis1D)timeOffsetSubset));
            }
            return Optional.of(result);
        }
        if (runAxisSubset.getNcoords() == 1) {
            double val = runAxisSubset.getCoordMidpoint(0);
            CalendarDate runDate = runAxisSubset.makeDate(val);
            Optional<TimeOffsetAxis> too = this.timeOffset.subsetFromTime(params, runDate);
            if (!too.isPresent()) {
                return Optional.empty(too.getErrorMessage());
            }
            TimeOffsetAxis timeOffsetSubset = too.get();
            result.add(timeOffsetSubset);
            if (makeCFcompliant) {
                result.add(this.makeCFTimeCoord(runAxisSubset, timeOffsetSubset));
            }
            return Optional.of(result);
        }
        isConstantForcast.set(true);
        CalendarDate dateWanted = params.isTrue("timePresent") ? CalendarDate.present() : (CalendarDate)params.get("time");
        if (dateWanted == null) {
            throw new IllegalStateException("Must have time parameter");
        }
        double wantOffset = runAxisSubset.convert(dateWanted);
        double start = this.timeOffset.getStartValue();
        double end = this.timeOffset.getEndValue();
        CoordAxisHelper helper = new CoordAxisHelper(this.timeOffset);
        ArrayList<Integer> runtimeIdx = new ArrayList<Integer>();
        ArrayList<Double> offset = new ArrayList<Double>();
        for (int i = 0; i < runAxisSubset.getNcoords(); ++i) {
            double runOffset = runAxisSubset.getCoordMidpoint(i);
            if (end + runOffset < wantOffset) continue;
            if (wantOffset < start + runOffset) break;
            int idx = helper.search(wantOffset - runOffset);
            if (idx < 0) continue;
            runtimeIdx.add(i);
            offset.add(wantOffset - runOffset);
        }
        int ncoords = runtimeIdx.size();
        double[] runValues = new double[ncoords];
        double[] offsetValues = new double[ncoords];
        int count = 0;
        for (int k = 0; k < ncoords; ++k) {
            offsetValues[count] = (Double)offset.get(k);
            runValues[count++] = runAxisSubset.getCoordMidpoint((Integer)runtimeIdx.get(k));
        }
        CoverageCoordAxisBuilder runbuilder = new CoverageCoordAxisBuilder(runAxisSubset).subset(null, CoverageCoordAxis.Spacing.irregularPoint, ncoords, runValues);
        CoverageCoordAxis1D runAxisSubset2 = new CoverageCoordAxis1D(runbuilder);
        CoverageCoordAxisBuilder timebuilder = new CoverageCoordAxisBuilder(this.timeOffset).subset(runAxisSubset2.getName(), CoverageCoordAxis.Spacing.irregularPoint, ncoords, offsetValues);
        TimeOffsetAxis timeOffsetSubset = new TimeOffsetAxis(timebuilder);
        CoverageCoordAxis scalarTimeCoord = this.makeScalarTimeCoord(wantOffset, runAxisSubset);
        return Optional.of(Lists.newArrayList(runAxisSubset2, timeOffsetSubset, scalarTimeCoord));
    }

    private CoverageCoordAxis makeScalarTimeCoord(double val, CoverageCoordAxis1D runAxisSubset) {
        String name = "constantForecastTime";
        String desc = "forecast time";
        AttributeContainerMutable atts = new AttributeContainerMutable(name);
        atts.addAttribute(new Attribute("units", runAxisSubset.getUnits()));
        atts.addAttribute(new Attribute("standard_name", "time"));
        atts.addAttribute(new Attribute("long_name", desc));
        atts.addAttribute(new Attribute("calendar", runAxisSubset.getCalendar().toString()));
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(name, runAxisSubset.getUnits(), desc, DataType.DOUBLE, AxisType.Time, atts, CoverageCoordAxis.DependenceType.scalar, null, CoverageCoordAxis.Spacing.regularPoint, 1, val, val, 0.0, null, null);
        builder.setIsSubset(true);
        return new CoverageCoordAxis1D(builder);
    }

    private CoverageCoordAxis makeCFTimeCoord(CoverageCoordAxis1D runAxisSubset, CoverageCoordAxis1D timeAxisSubset) {
        String name = timeAxisSubset.getName() + "Forecast";
        String desc = "forecast time";
        AttributeContainerMutable atts = new AttributeContainerMutable(name);
        atts.addAttribute(new Attribute("units", runAxisSubset.getUnits()));
        atts.addAttribute(new Attribute("standard_name", "time"));
        atts.addAttribute(new Attribute("long_name", desc));
        atts.addAttribute(new Attribute("calendar", runAxisSubset.getCalendar().toString()));
        if (runAxisSubset.getNcoords() == 1) {
            CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder();
            builder.name = name;
            builder.units = runAxisSubset.getUnits();
            builder.description = desc;
            builder.dataType = DataType.DOUBLE;
            builder.axisType = AxisType.Time;
            builder.attributes = atts;
            builder.dependenceType = CoverageCoordAxis.DependenceType.dependent;
            builder.setDependsOn(timeAxisSubset.getName());
            builder.spacing = timeAxisSubset.getSpacing();
            builder.ncoords = timeAxisSubset.ncoords;
            builder.isSubset = true;
            double offset = timeAxisSubset.getOffsetInTimeUnits(this.runAxis.getRefDate(), timeAxisSubset.getRefDate());
            switch (timeAxisSubset.getSpacing()) {
                case regularInterval: 
                case regularPoint: {
                    builder.startValue = timeAxisSubset.getStartValue() + offset;
                    builder.endValue = timeAxisSubset.getEndValue() + offset;
                    break;
                }
                case contiguousInterval: 
                case irregularPoint: 
                case discontiguousInterval: {
                    builder.values = timeAxisSubset.getValues();
                    int i = 0;
                    while (i < builder.values.length) {
                        int n = i++;
                        builder.values[n] = builder.values[n] + offset;
                    }
                    break;
                }
            }
            return new CoverageCoordAxis1D(builder);
        }
        return null;
    }
}

