/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.sedona.shaded.guava.primitives.Ints;
import org.apache.sedona.shaded.s2.EncodedInts;
import org.apache.sedona.shaded.s2.Platform;
import org.apache.sedona.shaded.s2.PrimitiveArrays;
import org.apache.sedona.shaded.s2.S2Coder;

public class UintVectorCoder
implements S2Coder<PrimitiveArrays.Longs> {
    public static final UintVectorCoder UINT32 = new UintVectorCoder(4);
    public static final UintVectorCoder UINT64 = new UintVectorCoder(8);
    private final int typeBytes;

    private UintVectorCoder(int typeBytes) {
        this.typeBytes = typeBytes;
    }

    @Override
    public void encode(PrimitiveArrays.Longs values, OutputStream output) throws IOException {
        long oneBits = 1L;
        for (int i = 0; i < values.length(); ++i) {
            oneBits |= values.get(i);
        }
        int bytesPerWord = (63 - Long.numberOfLeadingZeros(oneBits) >>> 3) + 1;
        long totalBytes = (long)values.length() * (long)this.typeBytes | (long)(bytesPerWord - 1);
        EncodedInts.writeVarint64(output, totalBytes);
        for (int i = 0; i < values.length(); ++i) {
            EncodedInts.encodeUintWithLength(output, values.get(i), bytesPerWord);
        }
    }

    @Override
    public PrimitiveArrays.Longs decode(final PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
        int bytesPerWord;
        int size;
        try {
            long totalBytes = data.readVarint64(cursor);
            if (totalBytes < 0L) {
                throw new IOException("Invalid input data, totalBytes = " + totalBytes);
            }
            size = Ints.checkedCast(totalBytes / (long)this.typeBytes);
            bytesPerWord = Ints.checkedCast((totalBytes & (long)(this.typeBytes - 1)) + 1L);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new IOException("Input data invalid or too short.", e);
        }
        final long offset = cursor.position;
        cursor.position += (long)size * (long)bytesPerWord;
        if (cursor.position > data.length()) {
            throw new IOException(Platform.formatString("Decoding from 'data' with length %s bytes, but %s bytes are required.", data.length(), cursor.position));
        }
        return new PrimitiveArrays.Longs(){

            @Override
            public long get(int position) {
                return data.readUintWithLength(offset + (long)position * (long)bytesPerWord, bytesPerWord);
            }

            @Override
            public int length() {
                return size;
            }
        };
    }

    @Override
    public boolean isLazy() {
        return true;
    }
}

