/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.projection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import lombok.Generated;

public enum DerivedColumn {
    AVG_COUNT_ALIAS("AVG_DERIVED_COUNT_"),
    AVG_SUM_ALIAS("AVG_DERIVED_SUM_"),
    ORDER_BY_ALIAS("ORDER_BY_DERIVED_"),
    GROUP_BY_ALIAS("GROUP_BY_DERIVED_"),
    AGGREGATION_DISTINCT_DERIVED("AGGREGATION_DISTINCT_DERIVED_");

    private static final DerivedColumn[] VALUES;
    private static final Collection<DerivedColumn> VALUES_WITHOUT_AGGREGATION_DISTINCT_DERIVED;
    private final String pattern;

    public String getDerivedColumnAlias(int derivedColumnCount) {
        return this.pattern + derivedColumnCount;
    }

    public static boolean isDerivedColumnName(String columnName) {
        for (DerivedColumn each : VALUES) {
            if (!columnName.startsWith(each.pattern)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDerivedColumn(String columnName) {
        for (DerivedColumn each : VALUES_WITHOUT_AGGREGATION_DISTINCT_DERIVED) {
            if (!columnName.startsWith(each.pattern)) continue;
            return true;
        }
        return false;
    }

    private static Collection<DerivedColumn> getValues() {
        ArrayList<DerivedColumn> result = new ArrayList<DerivedColumn>(Arrays.asList(DerivedColumn.values()));
        result.remove((Object)AGGREGATION_DISTINCT_DERIVED);
        return result;
    }

    @Generated
    private DerivedColumn(String pattern) {
        this.pattern = pattern;
    }

    static {
        VALUES = DerivedColumn.values();
        VALUES_WITHOUT_AGGREGATION_DISTINCT_DERIVED = DerivedColumn.getValues();
    }
}

