/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.merge.dql;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.mask.rule.MaskRule;
import org.apache.shardingsphere.mask.rule.MaskTable;
import org.apache.shardingsphere.mask.spi.MaskAlgorithm;

public final class MaskMergedResult
implements MergedResult {
    private final MaskRule maskRule;
    private final SelectStatementContext selectStatementContext;
    private final MergedResult mergedResult;

    public boolean next() throws SQLException {
        return this.mergedResult.next();
    }

    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        Optional columnProjection = this.selectStatementContext.getProjectionsContext().findColumnProjection(columnIndex);
        if (!columnProjection.isPresent()) {
            return this.mergedResult.getValue(columnIndex, type);
        }
        Optional<MaskTable> maskTable = this.maskRule.findMaskTable(((ColumnProjection)columnProjection.get()).getOriginalTable().getValue());
        if (!maskTable.isPresent()) {
            return this.mergedResult.getValue(columnIndex, type);
        }
        Optional<MaskAlgorithm> maskAlgorithm = maskTable.get().findAlgorithm(((ColumnProjection)columnProjection.get()).getName().getValue());
        if (!maskAlgorithm.isPresent()) {
            return this.mergedResult.getValue(columnIndex, type);
        }
        Object originalValue = this.mergedResult.getValue(columnIndex, Object.class);
        return null == originalValue ? null : maskAlgorithm.get().mask(originalValue);
    }

    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        return this.mergedResult.getCalendarValue(columnIndex, type, calendar);
    }

    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        return this.mergedResult.getInputStream(columnIndex, type);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.mergedResult.getCharacterStream(columnIndex);
    }

    public boolean wasNull() throws SQLException {
        return this.mergedResult.wasNull();
    }

    @Generated
    public MaskMergedResult(MaskRule maskRule, SelectStatementContext selectStatementContext, MergedResult mergedResult) {
        this.maskRule = maskRule;
        this.selectStatementContext = selectStatementContext;
        this.mergedResult = mergedResult;
    }
}

