/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.route.qualified.type;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.readwritesplitting.route.qualified.QualifiedReadwriteSplittingDataSourceRouter;
import org.apache.shardingsphere.readwritesplitting.route.standard.StandardReadwriteSplittingDataSourceRouter;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceGroupRule;

public final class QualifiedReadwriteSplittingTransactionalDataSourceRouter
implements QualifiedReadwriteSplittingDataSourceRouter {
    private final ConnectionContext connectionContext;
    private final StandardReadwriteSplittingDataSourceRouter standardRouter = new StandardReadwriteSplittingDataSourceRouter();

    @Override
    public boolean isQualified(SQLStatementContext sqlStatementContext, ReadwriteSplittingDataSourceGroupRule rule, HintValueContext hintValueContext) {
        return this.connectionContext.getTransactionContext().isInTransaction();
    }

    @Override
    public String route(ReadwriteSplittingDataSourceGroupRule rule) {
        switch (rule.getTransactionalReadQueryStrategy()) {
            case FIXED: {
                if (!this.connectionContext.getTransactionContext().getReadWriteSplitReplicaRoute().isPresent()) {
                    this.connectionContext.getTransactionContext().setReadWriteSplitReplicaRoute(this.standardRouter.route(rule));
                }
                return (String)this.connectionContext.getTransactionContext().getReadWriteSplitReplicaRoute().get();
            }
            case DYNAMIC: {
                return this.standardRouter.route(rule);
            }
        }
        return rule.getWriteDataSource();
    }

    @Generated
    public QualifiedReadwriteSplittingTransactionalDataSourceRouter(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }
}

