/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.callback.execute;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.callback.execute.StatementExecuteCallback;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class ExecuteCallbackFactory {
    private final String jdbcDriverType;

    public JDBCExecutorCallback<Boolean> newInstance(ShardingSphereDatabase database, final StatementExecuteCallback executeCallback, SQLStatement sqlStatement) {
        return new JDBCExecutorCallback<Boolean>(database.getProtocolType(), database.getResourceMetaData(), sqlStatement, SQLExecutorExceptionHandler.isExceptionThrown()){

            protected Boolean executeSQL(String sql, Statement statement, ConnectionMode connectionMode, DatabaseType storageType) throws SQLException {
                return "JDBC.STATEMENT".equals(ExecuteCallbackFactory.this.jdbcDriverType) ? executeCallback.execute(sql, statement) : ((PreparedStatement)statement).execute();
            }

            protected Optional<Boolean> getSaneResult(SQLStatement sqlStatement1, SQLException ex) {
                return Optional.empty();
            }
        };
    }

    @Generated
    public ExecuteCallbackFactory(String jdbcDriverType) {
        this.jdbcDriverType = jdbcDriverType;
    }
}

