/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.listener;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.infra.listener.ShardingContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineElasticJobListener
implements ElasticJobListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineElasticJobListener.class);
    private static final Map<String, Long> RUNNING_JOBS = new ConcurrentHashMap<String, Long>();

    public void beforeJobExecuted(ShardingContexts shardingContexts) {
        if (RUNNING_JOBS.containsKey(shardingContexts.getJobName())) {
            log.warn("{} already exists", (Object)shardingContexts.getJobName());
        }
        RUNNING_JOBS.put(shardingContexts.getJobName(), System.currentTimeMillis());
    }

    public void afterJobExecuted(ShardingContexts shardingContexts) {
        log.info("After {} job execute ", (Object)shardingContexts.getJobName());
        RUNNING_JOBS.remove(shardingContexts.getJobName());
    }

    public boolean isJobRunning(String jobId) {
        return RUNNING_JOBS.containsKey(jobId);
    }

    public String getType() {
        return PipelineElasticJobListener.class.getName();
    }
}

