/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.netty;

import com.google.common.hash.Hashing;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.sql.SQLException;
import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.authority.model.ShardingSpherePrivileges;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.data.pipeline.cdc.context.CDCConnectionContext;
import org.apache.shardingsphere.data.pipeline.cdc.exception.CDCExceptionWrapper;
import org.apache.shardingsphere.data.pipeline.cdc.exception.CDCLoginFailedException;
import org.apache.shardingsphere.data.pipeline.cdc.exception.EmptyCDCLoginRequestBodyException;
import org.apache.shardingsphere.data.pipeline.cdc.generator.CDCResponseUtils;
import org.apache.shardingsphere.data.pipeline.cdc.handler.CDCBackendHandler;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.request.AckStreamingRequestBody;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.request.CDCRequest;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.request.DropStreamingRequestBody;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.request.LoginRequestBody;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.request.StartStreamingRequestBody;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.request.StopStreamingRequestBody;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.request.StreamDataRequestBody;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.CDCResponse;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.ServerGreetingResult;
import org.apache.shardingsphere.data.pipeline.core.exception.param.PipelineInvalidParameterException;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.sqlstate.XOpenSQLState;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.kernel.category.PipelineSQLException;
import org.apache.shardingsphere.infra.exception.dialect.SQLExceptionTransformEngine;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.exception.mysql.exception.AccessDeniedException;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.protocol.FrontDatabaseProtocolTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDCChannelInboundHandler
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CDCChannelInboundHandler.class);
    private static final AttributeKey<CDCConnectionContext> CONNECTION_CONTEXT_KEY = AttributeKey.valueOf((String)"connection.context");
    private final CDCBackendHandler backendHandler = new CDCBackendHandler();

    public void channelActive(ChannelHandlerContext ctx) {
        CDCResponse response = CDCResponse.newBuilder().setServerGreetingResult(ServerGreetingResult.newBuilder().setServerVersion("5.5.2").setProtocolVersion("1").build()).setStatus(CDCResponse.Status.SUCCEED).build();
        ctx.writeAndFlush((Object)response);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        CDCConnectionContext connectionContext = (CDCConnectionContext)ctx.channel().attr(CONNECTION_CONTEXT_KEY).get();
        if (null != connectionContext && null != connectionContext.getJobId()) {
            this.backendHandler.stopStreaming(connectionContext.getJobId(), ctx.channel().id());
        }
        ctx.channel().attr(CONNECTION_CONTEXT_KEY).set(null);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ChannelFuture channelFuture;
        log.error("caught CDC resolution error", cause);
        if (cause instanceof CDCExceptionWrapper) {
            CDCExceptionWrapper wrapper = (CDCExceptionWrapper)cause;
            SQLException sqlException = SQLExceptionTransformEngine.toSQLException((Exception)wrapper.getCause(), (DatabaseType)FrontDatabaseProtocolTypeFactory.getDatabaseType());
            channelFuture = ctx.writeAndFlush((Object)CDCResponseUtils.failed((String)wrapper.getRequestId(), (String)sqlException.getSQLState(), (String)sqlException.getMessage()));
        } else {
            channelFuture = ctx.writeAndFlush((Object)CDCResponseUtils.failed((String)"", (String)XOpenSQLState.GENERAL_ERROR.getValue(), (String)String.valueOf(cause.getMessage())));
        }
        CDCConnectionContext connectionContext = (CDCConnectionContext)ctx.channel().attr(CONNECTION_CONTEXT_KEY).get();
        if (null == connectionContext) {
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        CDCConnectionContext connectionContext = (CDCConnectionContext)ctx.channel().attr(CONNECTION_CONTEXT_KEY).get();
        CDCRequest request = (CDCRequest)msg;
        if (null == connectionContext || request.hasLoginRequestBody()) {
            this.processLogin(ctx, request);
            return;
        }
        switch (request.getType()) {
            case STREAM_DATA: {
                this.processStreamDataRequest(ctx, request, connectionContext);
                break;
            }
            case ACK_STREAMING: {
                this.processAckStreamingRequest(request);
                break;
            }
            case STOP_STREAMING: {
                this.processStopStreamingRequest(ctx, request, connectionContext);
                break;
            }
            case START_STREAMING: {
                this.processStartStreamingRequest(ctx, request, connectionContext);
                break;
            }
            case DROP_STREAMING: {
                this.processDropStreamingRequest(ctx, request, connectionContext);
                break;
            }
            default: {
                log.warn("can't handle this type of request {}", (Object)request);
            }
        }
    }

    private void processLogin(ChannelHandlerContext ctx, CDCRequest request) {
        ShardingSpherePreconditions.checkState((request.hasLoginRequestBody() && request.getLoginRequestBody().hasBasicBody() ? 1 : 0) != 0, () -> new CDCExceptionWrapper(request.getRequestId(), (Exception)new EmptyCDCLoginRequestBodyException()));
        LoginRequestBody.BasicBody body = request.getLoginRequestBody().getBasicBody();
        AuthorityRule authorityRule = (AuthorityRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        ShardingSphereUser user = (ShardingSphereUser)authorityRule.findUser(new Grantee(body.getUsername(), this.getHostAddress(ctx))).orElseThrow(() -> new CDCExceptionWrapper(request.getRequestId(), (Exception)new CDCLoginFailedException()));
        ShardingSpherePreconditions.checkState((boolean)Objects.equals(Hashing.sha256().hashBytes(user.getPassword().getBytes()).toString().toUpperCase(), body.getPassword()), () -> new CDCExceptionWrapper(request.getRequestId(), (Exception)new CDCLoginFailedException()));
        ctx.channel().attr(CONNECTION_CONTEXT_KEY).set((Object)new CDCConnectionContext(user));
        ctx.writeAndFlush((Object)CDCResponseUtils.succeed((String)request.getRequestId()));
    }

    private void checkPrivileges(String requestId, Grantee grantee, String currentDatabase) {
        AuthorityRule authorityRule = (AuthorityRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findSingleRule(AuthorityRule.class).orElseThrow(() -> new CDCExceptionWrapper(requestId, (Exception)new MissingRequiredRuleException("authority")));
        ShardingSpherePrivileges privileges = (ShardingSpherePrivileges)authorityRule.findPrivileges(grantee).orElseThrow(() -> new CDCExceptionWrapper(requestId, (Exception)new AccessDeniedException(grantee.getUsername(), grantee.getHostname(), false)));
        ShardingSpherePreconditions.checkState((boolean)privileges.hasPrivileges(currentDatabase), () -> new CDCExceptionWrapper(requestId, (Exception)new UnknownDatabaseException(currentDatabase)));
    }

    private String getHostAddress(ChannelHandlerContext context) {
        SocketAddress socketAddress = context.channel().remoteAddress();
        return socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getAddress().getHostAddress() : socketAddress.toString();
    }

    private void processStreamDataRequest(ChannelHandlerContext ctx, CDCRequest request, CDCConnectionContext connectionContext) {
        if (!request.hasStreamDataRequestBody()) {
            throw new CDCExceptionWrapper(request.getRequestId(), (Exception)new PipelineInvalidParameterException("Stream data request body is empty"));
        }
        StreamDataRequestBody requestBody = request.getStreamDataRequestBody();
        if (requestBody.getDatabase().isEmpty()) {
            throw new CDCExceptionWrapper(request.getRequestId(), (Exception)new PipelineInvalidParameterException("Database is empty"));
        }
        if (requestBody.getSourceSchemaTableList().isEmpty()) {
            throw new CDCExceptionWrapper(request.getRequestId(), (Exception)new PipelineInvalidParameterException("Source schema table is empty"));
        }
        this.checkPrivileges(request.getRequestId(), connectionContext.getCurrentUser().getGrantee(), requestBody.getDatabase());
        try {
            CDCResponse response = this.backendHandler.streamData(request.getRequestId(), requestBody, connectionContext, ctx.channel());
            ctx.writeAndFlush((Object)response);
        }
        catch (PipelineSQLException ex) {
            throw new CDCExceptionWrapper(request.getRequestId(), (Exception)((Object)ex));
        }
    }

    private void processAckStreamingRequest(CDCRequest request) {
        if (!request.hasAckStreamingRequestBody()) {
            throw new CDCExceptionWrapper(request.getRequestId(), (Exception)new PipelineInvalidParameterException("Ack request body is empty"));
        }
        AckStreamingRequestBody requestBody = request.getAckStreamingRequestBody();
        if (requestBody.getAckId().isEmpty()) {
            throw new CDCExceptionWrapper(request.getRequestId(), (Exception)new PipelineInvalidParameterException("Ack request is empty"));
        }
        this.backendHandler.processAck(requestBody);
    }

    private void processStartStreamingRequest(ChannelHandlerContext ctx, CDCRequest request, CDCConnectionContext connectionContext) {
        if (!request.hasStartStreamingRequestBody()) {
            throw new CDCExceptionWrapper(request.getRequestId(), (Exception)new PipelineInvalidParameterException("Start streaming request body is empty"));
        }
        StartStreamingRequestBody requestBody = request.getStartStreamingRequestBody();
        if (requestBody.getStreamingId().isEmpty()) {
            throw new CDCExceptionWrapper(request.getRequestId(), (Exception)new PipelineInvalidParameterException("Streaming id is empty"));
        }
        String database = this.backendHandler.getDatabaseNameByJobId(requestBody.getStreamingId());
        this.checkPrivileges(request.getRequestId(), connectionContext.getCurrentUser().getGrantee(), database);
        this.backendHandler.startStreaming(requestBody.getStreamingId(), connectionContext, ctx.channel());
        ctx.writeAndFlush((Object)CDCResponseUtils.succeed((String)request.getRequestId()));
    }

    private void processStopStreamingRequest(ChannelHandlerContext ctx, CDCRequest request, CDCConnectionContext connectionContext) {
        StopStreamingRequestBody requestBody = request.getStopStreamingRequestBody();
        String database = this.backendHandler.getDatabaseNameByJobId(requestBody.getStreamingId());
        this.checkPrivileges(request.getRequestId(), connectionContext.getCurrentUser().getGrantee(), database);
        this.backendHandler.stopStreaming(requestBody.getStreamingId(), ctx.channel().id());
        connectionContext.setJobId(null);
        ctx.writeAndFlush((Object)CDCResponseUtils.succeed((String)request.getRequestId()));
    }

    private void processDropStreamingRequest(ChannelHandlerContext ctx, CDCRequest request, CDCConnectionContext connectionContext) {
        DropStreamingRequestBody requestBody = request.getDropStreamingRequestBody();
        this.checkPrivileges(request.getRequestId(), connectionContext.getCurrentUser().getGrantee(), this.backendHandler.getDatabaseNameByJobId(requestBody.getStreamingId()));
        this.backendHandler.dropStreaming(requestBody.getStreamingId());
        connectionContext.setJobId(null);
        ctx.writeAndFlush((Object)CDCResponseUtils.succeed((String)request.getRequestId()));
    }
}

