/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.authentication.authenticator.impl;

import com.google.common.base.Strings;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLAuthenticationMethod;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthenticationPluginData;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.proxy.frontend.mysql.authentication.authenticator.MySQLAuthenticator;

public final class MySQLNativePasswordAuthenticator
implements MySQLAuthenticator {
    public boolean authenticate(ShardingSphereUser user, Object[] authInfo) {
        byte[] authResponse = (byte[])authInfo[0];
        MySQLAuthenticationPluginData authPluginData = (MySQLAuthenticationPluginData)authInfo[1];
        return Strings.isNullOrEmpty((String)user.getPassword()) || Arrays.equals(this.getAuthCipherBytes(user.getPassword(), authPluginData.getAuthenticationPluginData()), authResponse);
    }

    private byte[] getAuthCipherBytes(String password, byte[] authenticationPluginData) {
        byte[] sha1Password = DigestUtils.sha1((String)password);
        byte[] doubleSha1Password = DigestUtils.sha1((byte[])sha1Password);
        byte[] concatBytes = new byte[authenticationPluginData.length + doubleSha1Password.length];
        System.arraycopy(authenticationPluginData, 0, concatBytes, 0, authenticationPluginData.length);
        System.arraycopy(doubleSha1Password, 0, concatBytes, authenticationPluginData.length, doubleSha1Password.length);
        byte[] sha1ConcatBytes = DigestUtils.sha1((byte[])concatBytes);
        return this.xor(sha1Password, sha1ConcatBytes);
    }

    private byte[] xor(byte[] input, byte[] secret) {
        byte[] result = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = (byte)(input[i] ^ secret[i]);
        }
        return result;
    }

    public String getAuthenticationMethodName() {
        return MySQLAuthenticationMethod.NATIVE.getMethodName();
    }
}

