/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.route.engine.type.broadcast;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.broadcast.route.engine.type.BroadcastRouteEngine;
import org.apache.shardingsphere.broadcast.rule.BroadcastRule;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;

public final class BroadcastTableBroadcastRouteEngine
implements BroadcastRouteEngine {
    private final Collection<String> broadcastTableNames;

    @Override
    public RouteContext route(BroadcastRule rule) {
        RouteContext result = new RouteContext();
        Collection<String> logicTableNames = rule.getBroadcastTableNames(this.broadcastTableNames);
        RouteContext toBeAddedRouteContext = logicTableNames.isEmpty() ? this.getRouteContext(rule) : this.getRouteContext(rule, logicTableNames);
        result.getRouteUnits().addAll(toBeAddedRouteContext.getRouteUnits());
        return result;
    }

    private RouteContext getRouteContext(BroadcastRule rule) {
        RouteContext result = new RouteContext();
        for (String each : rule.getDataSourceNames()) {
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(each, each), Collections.singletonList(new RouteMapper("", ""))));
        }
        return result;
    }

    private RouteContext getRouteContext(BroadcastRule rule, Collection<String> logicTableNames) {
        RouteContext result = new RouteContext();
        Collection<RouteMapper> tableRouteMappers = this.getTableRouteMappers(logicTableNames);
        for (String each : rule.getDataSourceNames()) {
            RouteMapper dataSourceMapper = new RouteMapper(each, each);
            result.getRouteUnits().add(new RouteUnit(dataSourceMapper, tableRouteMappers));
        }
        return result;
    }

    private Collection<RouteMapper> getTableRouteMappers(Collection<String> logicTableNames) {
        LinkedList<RouteMapper> result = new LinkedList<RouteMapper>();
        for (String each : logicTableNames) {
            result.add(new RouteMapper(each, each));
        }
        return result;
    }

    @Generated
    public BroadcastTableBroadcastRouteEngine(Collection<String> broadcastTableNames) {
        this.broadcastTableNames = broadcastTableNames;
    }
}

