/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.instance.metadata.jdbc.JDBCInstanceMetaData;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.deliver.DeliverEventSubscriber;
import org.apache.shardingsphere.mode.deliver.DeliverEventSubscriberRegistry;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.listener.DataChangedEventListenerRegistry;
import org.apache.shardingsphere.mode.manager.cluster.exception.MissingRequiredClusterRepositoryConfigurationException;
import org.apache.shardingsphere.mode.manager.cluster.lock.ClusterLockContext;
import org.apache.shardingsphere.mode.manager.cluster.persist.service.GlobalLockPersistService;
import org.apache.shardingsphere.mode.manager.cluster.workerid.ClusterWorkerIdGenerator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class ClusterContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ContextManagerBuilderParameter param, EventBusContext eventBusContext) throws SQLException {
        ModeConfiguration modeConfig = param.getModeConfiguration();
        ClusterPersistRepositoryConfiguration config = (ClusterPersistRepositoryConfiguration)modeConfig.getRepository();
        ComputeNodeInstanceContext computeNodeInstanceContext = new ComputeNodeInstanceContext(new ComputeNodeInstance(param.getInstanceMetaData(), param.getLabels()), modeConfig, eventBusContext);
        ClusterPersistRepository repository = this.getClusterPersistRepository(config, computeNodeInstanceContext);
        ClusterLockContext lockContext = new ClusterLockContext(new GlobalLockPersistService(repository));
        computeNodeInstanceContext.init((WorkerIdGenerator)new ClusterWorkerIdGenerator(repository, param.getInstanceMetaData().getId()), (LockContext)lockContext);
        MetaDataPersistService metaDataPersistService = new MetaDataPersistService((PersistRepository)repository);
        MetaDataContexts metaDataContexts = MetaDataContextsFactory.create((MetaDataPersistService)metaDataPersistService, (ContextManagerBuilderParameter)param, (ComputeNodeInstanceContext)computeNodeInstanceContext);
        ContextManager result = new ContextManager(metaDataContexts, computeNodeInstanceContext, (PersistRepository)repository);
        this.registerOnline(computeNodeInstanceContext, param, result, (PersistRepository)repository);
        return result;
    }

    private ClusterPersistRepository getClusterPersistRepository(ClusterPersistRepositoryConfiguration config, ComputeNodeInstanceContext computeNodeInstanceContext) {
        ShardingSpherePreconditions.checkNotNull((Object)config, MissingRequiredClusterRepositoryConfigurationException::new);
        ClusterPersistRepository result = (ClusterPersistRepository)TypedSPILoader.getService(ClusterPersistRepository.class, (Object)config.getType(), (Properties)config.getProps());
        result.init(config, computeNodeInstanceContext);
        return result;
    }

    private void registerOnline(ComputeNodeInstanceContext computeNodeInstanceContext, ContextManagerBuilderParameter param, ContextManager contextManager, PersistRepository repository) {
        contextManager.getPersistServiceFacade().getComputeNodePersistService().registerOnline(computeNodeInstanceContext.getInstance());
        contextManager.getComputeNodeInstanceContext().getClusterInstanceRegistry().getAllClusterInstances().addAll(contextManager.getPersistServiceFacade().getComputeNodePersistService().loadAllInstances());
        new DataChangedEventListenerRegistry(contextManager, this.getDatabaseNames(param, contextManager.getPersistServiceFacade().getMetaDataPersistService())).register();
        DeliverEventSubscriberRegistry deliverEventSubscriberRegistry = new DeliverEventSubscriberRegistry(contextManager.getComputeNodeInstanceContext().getEventBusContext());
        deliverEventSubscriberRegistry.register(this.createDeliverEventSubscribers(repository));
    }

    private Collection<String> getDatabaseNames(ContextManagerBuilderParameter param, MetaDataPersistService metaDataPersistService) {
        return param.getInstanceMetaData() instanceof JDBCInstanceMetaData ? param.getDatabaseConfigs().keySet() : metaDataPersistService.getDatabaseMetaDataFacade().getDatabase().loadAllDatabaseNames();
    }

    private Collection<DeliverEventSubscriber> createDeliverEventSubscribers(PersistRepository repository) {
        LinkedList<DeliverEventSubscriber> result = new LinkedList<DeliverEventSubscriber>();
        for (DeliverEventSubscriber each : ShardingSphereServiceLoader.getServiceInstances(DeliverEventSubscriber.class)) {
            each.setRepository(repository);
            result.add(each);
        }
        return result;
    }

    public String getType() {
        return "Cluster";
    }
}

