/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.listener.type;

import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.spi.type.ordered.cache.OrderedServicesCache;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata.MetaDataChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.rule.RuleConfigurationChangedHandler;
import org.apache.shardingsphere.mode.node.path.metadata.DatabaseMetaDataNodePath;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;

public final class DatabaseMetaDataChangedListener
implements DataChangedEventListener {
    private final ContextManager contextManager;

    public void onChange(DataChangedEvent event) {
        Optional databaseName = DatabaseMetaDataNodePath.findDatabaseName((String)event.getKey(), (boolean)true);
        if (!databaseName.isPresent()) {
            return;
        }
        OrderedServicesCache.clearCache();
        if (new MetaDataChangedHandler(this.contextManager).handle((String)databaseName.get(), event)) {
            return;
        }
        try {
            new RuleConfigurationChangedHandler(this.contextManager).handle((String)databaseName.get(), event);
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }

    @Generated
    public DatabaseMetaDataChangedListener(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

