/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine.transaction;

import java.sql.SQLException;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.dialect.SQLExceptionTransformEngine;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.transaction.implicit.ImplicitTransactionCallback;
import org.apache.shardingsphere.transaction.rule.TransactionRule;

public final class DriverTransactionalExecutor {
    private final ShardingSphereConnection connection;
    private final TransactionRule transactionRule;

    public DriverTransactionalExecutor(ShardingSphereConnection connection) {
        this.connection = connection;
        this.transactionRule = (TransactionRule)connection.getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(TransactionRule.class);
    }

    public <T> T execute(ShardingSphereDatabase database, ExecutionContext executionContext, ImplicitTransactionCallback<T> callback) throws SQLException {
        boolean isImplicitCommitTransaction = this.transactionRule.isImplicitCommitTransaction(executionContext, this.connection.getDatabaseConnectionManager().getConnectionTransaction(), this.connection.getAutoCommit());
        return (T)(isImplicitCommitTransaction ? this.executeWithImplicitCommit(database, callback) : callback.execute());
    }

    private <T> T executeWithImplicitCommit(ShardingSphereDatabase database, ImplicitTransactionCallback<T> callback) throws SQLException {
        try {
            this.connection.setAutoCommit(false);
            Object result = callback.execute();
            this.connection.commit();
            Object object = result;
            return (T)object;
        }
        catch (Exception ex) {
            this.connection.rollback();
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)database.getProtocolType());
        }
        finally {
            this.connection.setAutoCommit(true);
        }
    }
}

