/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.index;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.PostgreSQLDDLTemplateExecutor;
import org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.template.PostgreSQLPipelineFreemarkerManager;
import org.postgresql.jdbc.PgArray;

public final class PostgreSQLIndexSQLGenerator {
    private static final Integer PG_INDEX_INCLUDE_VERSION = 11;
    private final PostgreSQLDDLTemplateExecutor templateExecutor;

    public PostgreSQLIndexSQLGenerator(Connection connection, int majorVersion, int minorVersion) {
        this.templateExecutor = new PostgreSQLDDLTemplateExecutor(connection, majorVersion, minorVersion);
    }

    public String generate(Map<String, Object> context) throws SQLException {
        StringBuilder result = new StringBuilder();
        for (Map<String, Object> each : this.getIndexNodes(context)) {
            if (each.containsKey("is_inherited") && ((Boolean)each.get("is_inherited")).booleanValue()) continue;
            result.append(this.getIndexSQL(context, each));
        }
        return result.toString().trim();
    }

    private Collection<Map<String, Object>> getIndexNodes(Map<String, Object> context) {
        return this.templateExecutor.executeByTemplate(Collections.singletonMap("tid", context.get("tid")), "component/indexes/%s/nodes.ftl");
    }

    private String getIndexSQL(Map<String, Object> context, Map<String, Object> indexNode) throws SQLException {
        Map<String, Object> indexData = this.getIndexData(context, indexNode);
        this.appendColumnDetails(indexData, (Long)indexNode.get("oid"));
        if (this.templateExecutor.getMajorVersion() >= PG_INDEX_INCLUDE_VERSION) {
            Collection<Map<String, Object>> includeDetails = this.templateExecutor.executeByTemplate(Collections.singletonMap("idx", indexNode.get("oid")), "component/indexes/%s/include_details.ftl");
            indexData.put("include", includeDetails.stream().map(each -> each.get("colname")).collect(Collectors.toList()));
        }
        return this.doGenerateIndexSQL(indexData);
    }

    private Map<String, Object> getIndexData(Map<String, Object> context, Map<String, Object> indexNode) {
        Collection<Map<String, Object>> indexProps = this.fetchIndexProperties(context, indexNode);
        Map<String, Object> result = indexProps.iterator().next();
        result.put("schema", context.get("schema"));
        result.put("table", context.get("name"));
        return result;
    }

    private Collection<Map<String, Object>> fetchIndexProperties(Map<String, Object> context, Map<String, Object> indexNode) {
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>(4, 1.0f);
        param.put("did", context.get("did"));
        param.put("tid", context.get("tid"));
        param.put("idx", indexNode.get("oid"));
        param.put("datlastsysoid", context.get("datlastsysoid"));
        return this.templateExecutor.executeByTemplate(param, "component/indexes/%s/properties.ftl");
    }

    private void appendColumnDetails(Map<String, Object> indexData, Long indexId) throws SQLException {
        LinkedList<Map<String, Object>> columns = new LinkedList<Map<String, Object>>();
        LinkedList<String> columnDisplays = new LinkedList<String>();
        for (Map<String, Object> each : this.templateExecutor.executeByTemplate(Collections.singletonMap("idx", indexId), "component/indexes/%s/column_details.ftl")) {
            columns.add(this.getColumnData(indexData, each));
            columnDisplays.add(this.getColumnPropertyDisplayData(each, indexData));
        }
        indexData.put("columns", columns);
        indexData.put("columns_csv", String.join((CharSequence)", ", columnDisplays));
    }

    private Map<String, Object> getColumnData(Map<String, Object> indexData, Map<String, Object> columnDetail) throws SQLException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(5, 1.0f);
        result.put("colname", columnDetail.get("attdef"));
        result.put("collspcname", columnDetail.get("collnspname"));
        result.put("op_class", columnDetail.get("opcname"));
        if ("btree".equals(indexData.get("amname"))) {
            result.put("sort_order", this.isSortOrder(columnDetail));
            result.put("nulls", this.isNulls(columnDetail));
        }
        return result;
    }

    private boolean isSortOrder(Map<String, Object> columnDetail) throws SQLException {
        if (null == columnDetail.get("options")) {
            return false;
        }
        String[] options = (String[])((PgArray)columnDetail.get("options")).getArray();
        return options.length > 0 && "DESC".equals(options[0]);
    }

    private Object isNulls(Map<String, Object> columnDetail) throws SQLException {
        if (null == columnDetail.get("options")) {
            return false;
        }
        String[] options = (String[])((PgArray)columnDetail.get("options")).getArray();
        return options.length > 1 && options[1].split(" ").length > 1 && "FIRST".equals(options[1].split(" ")[1]);
    }

    private String getColumnPropertyDisplayData(Map<String, Object> columnDetail, Map<String, Object> indexData) throws SQLException {
        String result = (String)columnDetail.get("attdef");
        if (null != columnDetail.get("collnspname")) {
            result = result + " COLLATE " + columnDetail.get("collnspname");
        }
        if (null != columnDetail.get("opcname")) {
            result = result + " " + columnDetail.get("opcname");
        }
        if ("btree".equals(indexData.get("amname"))) {
            String[] options = (String[])((PgArray)columnDetail.get("options")).getArray();
            if (options.length > 0) {
                result = result + " " + options[0];
            }
            if (options.length > 1) {
                result = result + " " + options[1];
            }
        }
        return result;
    }

    private String doGenerateIndexSQL(Map<String, Object> indexData) {
        return String.join((CharSequence)System.lineSeparator(), PostgreSQLPipelineFreemarkerManager.getSQLByVersion(indexData, "component/indexes/%s/create.ftl", this.templateExecutor.getMajorVersion(), this.templateExecutor.getMinorVersion()), PostgreSQLPipelineFreemarkerManager.getSQLByVersion(indexData, "component/indexes/%s/alter.ftl", this.templateExecutor.getMajorVersion(), this.templateExecutor.getMinorVersion()));
    }
}

