/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.inflater;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sis.pending.jdk.JDK13;
import org.apache.sis.storage.geotiff.inflater.CompressionChannel;
import org.apache.sis.storage.geotiff.inflater.PixelChannel;
import org.apache.sis.util.ArraysExt;

abstract class PredictorChannel
extends PixelChannel {
    private final CompressionChannel input;
    private byte[] deferred;
    private int deferredCount;

    protected PredictorChannel(CompressionChannel input) {
        this.input = input;
        this.deferred = ArraysExt.EMPTY_BYTE;
    }

    @Override
    public void setInputRegion(long start, long byteCount) throws IOException {
        this.input.setInputRegion(start, byteCount);
        this.deferredCount = 0;
    }

    protected abstract int apply(ByteBuffer var1, int var2);

    @Override
    public int read(ByteBuffer target) throws IOException {
        int start = target.position();
        if (this.deferredCount != 0) {
            int n = Math.min(this.deferredCount, target.remaining());
            target.put(this.deferred, 0, n);
            System.arraycopy(this.deferred, n, this.deferred, 0, this.deferredCount -= n);
        }
        this.input.read(target);
        int end = this.apply(target, start);
        int remaining = target.position() - end;
        if (remaining != 0) {
            int length = this.deferredCount + remaining;
            if (length > this.deferred.length) {
                this.deferred = new byte[length];
            }
            JDK13.get((ByteBuffer)target, (int)end, (byte[])this.deferred, (int)this.deferredCount, (int)remaining);
            target.position(end);
            this.deferredCount = length;
        }
        return end - start;
    }

    @Override
    public final boolean isOpen() {
        return this.input.isOpen();
    }

    @Override
    public final void close() {
        this.input.close();
    }
}

