/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql;

import com.linecorp.armeria.common.HttpMethod;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserBuilder;
import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLScalarType;
import java.util.Collections;
import org.apache.skywalking.oap.query.graphql.GraphQLQueryConfig;
import org.apache.skywalking.oap.query.graphql.GraphQLQueryHandler;
import org.apache.skywalking.oap.query.graphql.resolver.AggregationQuery;
import org.apache.skywalking.oap.query.graphql.resolver.AlarmQuery;
import org.apache.skywalking.oap.query.graphql.resolver.AsyncProfilerMutation;
import org.apache.skywalking.oap.query.graphql.resolver.AsyncProfilerQuery;
import org.apache.skywalking.oap.query.graphql.resolver.BrowserLogQuery;
import org.apache.skywalking.oap.query.graphql.resolver.ContinuousProfilingMutation;
import org.apache.skywalking.oap.query.graphql.resolver.ContinuousProfilingQuery;
import org.apache.skywalking.oap.query.graphql.resolver.EBPFProcessProfilingMutation;
import org.apache.skywalking.oap.query.graphql.resolver.EBPFProcessProfilingQuery;
import org.apache.skywalking.oap.query.graphql.resolver.EventQuery;
import org.apache.skywalking.oap.query.graphql.resolver.HealthQuery;
import org.apache.skywalking.oap.query.graphql.resolver.HierarchyQuery;
import org.apache.skywalking.oap.query.graphql.resolver.LogQuery;
import org.apache.skywalking.oap.query.graphql.resolver.LogTestQuery;
import org.apache.skywalking.oap.query.graphql.resolver.MetadataQuery;
import org.apache.skywalking.oap.query.graphql.resolver.MetadataQueryV2;
import org.apache.skywalking.oap.query.graphql.resolver.MetricQuery;
import org.apache.skywalking.oap.query.graphql.resolver.MetricsExpressionQuery;
import org.apache.skywalking.oap.query.graphql.resolver.MetricsQuery;
import org.apache.skywalking.oap.query.graphql.resolver.Mutation;
import org.apache.skywalking.oap.query.graphql.resolver.OndemandLogQuery;
import org.apache.skywalking.oap.query.graphql.resolver.ProfileMutation;
import org.apache.skywalking.oap.query.graphql.resolver.ProfileQuery;
import org.apache.skywalking.oap.query.graphql.resolver.Query;
import org.apache.skywalking.oap.query.graphql.resolver.RecordsQuery;
import org.apache.skywalking.oap.query.graphql.resolver.TopNRecordsQuery;
import org.apache.skywalking.oap.query.graphql.resolver.TopologyQuery;
import org.apache.skywalking.oap.query.graphql.resolver.TraceQuery;
import org.apache.skywalking.oap.query.graphql.resolver.UIConfigurationManagement;
import org.apache.skywalking.oap.server.core.query.QueryModule;
import org.apache.skywalking.oap.server.core.server.HTTPHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;

public class GraphQLQueryProvider
extends ModuleProvider {
    protected GraphQLQueryConfig config;
    protected final SchemaParserBuilder schemaBuilder = SchemaParser.newParser();

    public String name() {
        return "graphql";
    }

    public Class<? extends ModuleDefine> module() {
        return QueryModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<GraphQLQueryConfig>(){

            public Class type() {
                return GraphQLQueryConfig.class;
            }

            public void onInitialized(GraphQLQueryConfig initialized) {
                GraphQLQueryProvider.this.config = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException {
        MetadataQueryV2 metadataQueryV2 = new MetadataQueryV2(this.getManager());
        this.schemaBuilder.file("query-protocol/common.graphqls").resolvers(new GraphQLResolver[]{new Query(), new Mutation(), new HealthQuery(this.getManager())}).file("query-protocol/metadata.graphqls").resolvers(new GraphQLResolver[]{new MetadataQuery(this.getManager())}).file("query-protocol/topology.graphqls").resolvers(new GraphQLResolver[]{new TopologyQuery(this.getManager())}).file("query-protocol/metrics-v3.graphqls").resolvers(new GraphQLResolver[]{new MetricsExpressionQuery(this.getManager())}).file("query-protocol/metric.graphqls").resolvers(new GraphQLResolver[]{new MetricQuery(this.getManager())}).file("query-protocol/aggregation.graphqls").resolvers(new GraphQLResolver[]{new AggregationQuery(this.getManager())}).file("query-protocol/top-n-records.graphqls").resolvers(new GraphQLResolver[]{new TopNRecordsQuery(this.getManager())}).file("query-protocol/metrics-v2.graphqls").resolvers(new GraphQLResolver[]{new MetricsQuery(this.getManager())}).file("query-protocol/trace.graphqls").resolvers(new GraphQLResolver[]{new TraceQuery(this.getManager())}).file("query-protocol/alarm.graphqls").resolvers(new GraphQLResolver[]{new AlarmQuery(this.getManager())}).file("query-protocol/log.graphqls").resolvers(new GraphQLResolver[]{new LogQuery(this.getManager()), new LogTestQuery(this.getManager(), this.config)}).file("query-protocol/profile.graphqls").resolvers(new GraphQLResolver[]{new ProfileQuery(this.getManager()), new ProfileMutation(this.getManager())}).file("query-protocol/ui-configuration.graphqls").resolvers(new GraphQLResolver[]{new UIConfigurationManagement(this.getManager(), this.config)}).file("query-protocol/browser-log.graphqls").resolvers(new GraphQLResolver[]{new BrowserLogQuery(this.getManager())}).file("query-protocol/event.graphqls").resolvers(new GraphQLResolver[]{new EventQuery(this.getManager())}).file("query-protocol/metadata-v2.graphqls").resolvers(new GraphQLResolver[]{metadataQueryV2}).file("query-protocol/ebpf-profiling.graphqls").resolvers(new GraphQLResolver[]{new EBPFProcessProfilingQuery(this.getManager()), new EBPFProcessProfilingMutation(this.getManager())}).file("query-protocol/continuous-profiling.graphqls").resolvers(new GraphQLResolver[]{new ContinuousProfilingQuery(this.getManager()), new ContinuousProfilingMutation(this.getManager())}).file("query-protocol/record.graphqls").resolvers(new GraphQLResolver[]{new RecordsQuery(this.getManager())}).file("query-protocol/hierarchy.graphqls").resolvers(new GraphQLResolver[]{new HierarchyQuery(this.getManager())}).file("query-protocol/async-profiler.graphqls").resolvers(new GraphQLResolver[]{new AsyncProfilerQuery(this.getManager()), new AsyncProfilerMutation(this.getManager())});
        if (this.config.isEnableOnDemandPodLog()) {
            this.schemaBuilder.file("query-protocol/ondemand-pod-log.graphqls").resolvers(new GraphQLResolver[]{new OndemandLogQuery(metadataQueryV2)});
        }
        this.schemaBuilder.scalars(new GraphQLScalarType[]{ExtendedScalars.GraphQLLong});
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        HTTPHandlerRegister service = (HTTPHandlerRegister)this.getManager().find("core").provider().getService(HTTPHandlerRegister.class);
        service.addHandler((Object)new GraphQLQueryHandler(this.getManager(), this.config, this.schemaBuilder.build().makeExecutableSchema()), Collections.singletonList(HttpMethod.POST));
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException {
    }

    public String[] requiredModules() {
        return new String[0];
    }
}

