/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class StorageID {
    private final List<Fragment> fragments = new ArrayList<Fragment>(2);
    private boolean sealed = false;
    private String builtID;

    public StorageID append(String name, String value) {
        if (StringUtil.isBlank((String)name)) {
            throw new IllegalArgumentException("The name of storage ID should not be null or empty.");
        }
        if (this.sealed) {
            throw new IllegalStateException("The storage ID is sealed. Can't append a new fragment, name=" + name);
        }
        this.fragments.add(new Fragment(new String[]{name}, String.class, false, value));
        return this;
    }

    public StorageID append(String name, long value) {
        if (StringUtil.isBlank((String)name)) {
            throw new IllegalArgumentException("The name of storage ID should not be null or empty.");
        }
        if (this.sealed) {
            throw new IllegalStateException("The storage ID is sealed. Can't append a new fragment, name=" + name);
        }
        this.fragments.add(new Fragment(new String[]{name}, Long.class, false, value));
        return this;
    }

    public StorageID append(String name, int value) {
        if (StringUtil.isBlank((String)name)) {
            throw new IllegalArgumentException("The name of storage ID should not be null or empty.");
        }
        if (this.sealed) {
            throw new IllegalStateException("The storage ID is sealed. Can't append a new fragment, name=" + name);
        }
        this.fragments.add(new Fragment(new String[]{name}, Integer.class, false, value));
        return this;
    }

    public StorageID appendMutant(String[] source, long value) {
        if (this.sealed) {
            throw new IllegalStateException("The storage ID is sealed. Can't append a new fragment, source=" + Arrays.toString(source));
        }
        this.fragments.add(new Fragment(source, Long.class, true, value));
        return this;
    }

    public StorageID appendMutant(String[] source, String value) {
        if (this.sealed) {
            throw new IllegalStateException("The storage ID is sealed. Can't append a new fragment, source=" + Arrays.toString(source));
        }
        this.fragments.add(new Fragment(source, String.class, true, value));
        return this;
    }

    public String build() {
        this.sealed = true;
        if (this.builtID == null) {
            this.builtID = Joiner.on((String)"_").join(this.fragments);
        }
        return this.builtID;
    }

    public List<Fragment> read() {
        this.sealed = true;
        return Collections.unmodifiableList(this.fragments);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StorageID)) {
            return false;
        }
        StorageID other = (StorageID)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Fragment> this$fragments = this.fragments;
        List<Fragment> other$fragments = other.fragments;
        return !(this$fragments == null ? other$fragments != null : !((Object)this$fragments).equals(other$fragments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StorageID;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Fragment> $fragments = this.fragments;
        result = result * 59 + ($fragments == null ? 43 : ((Object)$fragments).hashCode());
        return result;
    }

    public static class Fragment {
        private final String[] name;
        private final Class<?> type;
        private final boolean mutate;
        private final Object value;

        public Optional<String[]> getName() {
            return Optional.ofNullable(this.name);
        }

        public String toString() {
            return this.value.toString();
        }

        @Generated
        public Fragment(String[] name, Class<?> type, boolean mutate, Object value) {
            this.name = name;
            this.type = type;
            this.mutate = mutate;
            this.value = value;
        }

        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @Generated
        public boolean isMutate() {
            return this.mutate;
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fragment)) {
                return false;
            }
            Fragment other = (Fragment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.name, other.name)) {
                return false;
            }
            Object this$value = this.value;
            Object other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Fragment;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.name);
            Object $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

