/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.property.v1.BanyandbProperty;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingPolicy;
import org.apache.skywalking.oap.server.core.storage.profiling.continuous.IContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBContinuousProfilingPolicyDAO
extends AbstractBanyanDBDAO
implements IContinuousProfilingPolicyDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBContinuousProfilingPolicyDAO.class);

    public BanyanDBContinuousProfilingPolicyDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public void savePolicy(ContinuousProfilingPolicy policy) throws IOException {
        try {
            ((BanyanDBStorageClient)this.getClient()).apply(this.applyAll(policy));
        }
        catch (IOException e) {
            log.error("fail to save policy", (Throwable)e);
        }
    }

    public BanyandbProperty.Property applyAll(ContinuousProfilingPolicy policy) {
        return BanyandbProperty.Property.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup("property").setName("continuous_profiling_policy")).setId(policy.id().build()).addTags(TagAndValue.newStringTag((String)"uuid", (String)policy.getUuid()).build()).addTags(TagAndValue.newStringTag((String)"configuration_json", (String)policy.getConfigurationJson()).build()).build();
    }

    public List<ContinuousProfilingPolicy> queryPolicies(List<String> serviceIdList) throws IOException {
        return serviceIdList.stream().map(s -> {
            try {
                return ((BanyanDBStorageClient)this.getClient()).queryProperty("property", "continuous_profiling_policy", (String)s);
            }
            catch (IOException e) {
                log.warn("query policy error", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).map(properties -> {
            ContinuousProfilingPolicy policy = new ContinuousProfilingPolicy();
            policy.setServiceId(properties.getId());
            for (BanyandbModel.Tag tag : properties.getTagsList()) {
                TagAndValue tagAndValue = TagAndValue.fromProtobuf((BanyandbModel.Tag)tag);
                if (tagAndValue.getTagName().equals("configuration_json")) {
                    policy.setConfigurationJson((String)tagAndValue.getValue());
                    continue;
                }
                if (!tagAndValue.getTagName().equals("uuid")) continue;
                policy.setUuid((String)tagAndValue.getValue());
            }
            return policy;
        }).collect(Collectors.toList());
    }
}

