/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HllSketchEstimate$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the estimated number of unique values given the binary representation\n    of a Datasketches HllSketch. ", examples="\n    Examples:\n      > SELECT _FUNC_(hll_sketch_agg(col)) FROM VALUES (1), (1), (2), (2), (3) tab(col);\n       3\n  ", group="misc_funcs", since="3.5.0")
@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001B\r\u001b\u0001\u001eB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\")1\u000b\u0001C\u0001)\")q\u000b\u0001C)1\")1\f\u0001C!9\")Q\r\u0001C!M\")\u0001\u000f\u0001C!c\")Q\u000f\u0001C!m\"9A\u0010AA\u0001\n\u0003i\b\u0002C@\u0001#\u0003%\t!!\u0001\t\u0013\u0005]\u0001!!A\u0005B\u0005e\u0001\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002<\u0001\t\t\u0011\"\u0011\u0002>!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003/\u0002\u0011\u0011!C!\u00033B\u0011\"!\u0018\u0001\u0003\u0003%\t%a\u0018\b\u0013\u0005\r%$!A\t\u0002\u0005\u0015e\u0001C\r\u001b\u0003\u0003E\t!a\"\t\rM\u001bB\u0011AAP\u0011%\t\tkEA\u0001\n\u000b\n\u0019\u000bC\u0005\u0002&N\t\t\u0011\"!\u0002(\"I\u00111V\n\u0002\u0002\u0013\u0005\u0015Q\u0016\u0005\n\u0003s\u001b\u0012\u0011!C\u0005\u0003w\u0013\u0011\u0003\u00137m'.,Go\u00195FgRLW.\u0019;f\u0015\tYB$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000f\u001f\u0003!\u0019\u0017\r^1msN$(BA\u0010!\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO\u000e\u00011c\u0002\u0001)YI*DH\u0011\t\u0003S)j\u0011AG\u0005\u0003Wi\u0011q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003[Aj\u0011A\f\u0006\u0003_i\tqaY8eK\u001e,g.\u0003\u00022]\ty1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000e\u0005\u0002*g%\u0011AG\u0007\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001c:\u001d\tIs'\u0003\u000295\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001e<\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!\u0001\u000f\u000e\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\u000fA\u0013x\u000eZ;diB\u00111I\u0013\b\u0003\t&s!!\u0012%\u000e\u0003\u0019S!a\u0012\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0014B\u0001\u001d?\u0013\tYEJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u00029}\u0005)1\r[5mIV\tq\n\u0005\u0002*!&\u0011\u0011K\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003+Z\u0003\"!\u000b\u0001\t\u000b5\u001b\u0001\u0019A(\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\t)\u0016\fC\u0003[\t\u0001\u0007q*\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002;B\u0011aL\u0019\b\u0003?\u0002\u0004\"!\u0012 \n\u0005\u0005t\u0014A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!\u0019 \u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001h!\r\u0019\u0005N[\u0005\u0003S2\u00131aU3r!\tYg.D\u0001m\u0015\tig$A\u0003usB,7/\u0003\u0002pY\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\t!\u000f\u0005\u0002lg&\u0011A\u000f\u001c\u0002\t\t\u0006$\u0018\rV=qK\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0011qO\u001f\t\u0003{aL!!\u001f \u0003\u0007\u0005s\u0017\u0010C\u0003|\u0011\u0001\u0007q/A\u0003j]B,H/\u0001\u0003d_BLHCA+\u007f\u0011\u001di\u0015\u0002%AA\u0002=\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0004)\u001aq*!\u0002,\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0005?\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\tYAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u000e!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\tA\u0001\\1oO*\u0011\u0011QE\u0001\u0005U\u00064\u0018-C\u0002d\u0003?\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\f\u0011\u0007u\ny#C\u0002\u00022y\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2a^A\u001c\u0011%\tI$DA\u0001\u0002\u0004\ti#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u007f\u0001R!!\u0011\u0002H]l!!a\u0011\u000b\u0007\u0005\u0015c(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0013\u0002D\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty%!\u0016\u0011\u0007u\n\t&C\u0002\u0002Ty\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002:=\t\t\u00111\u0001x\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005m\u00111\f\u0005\n\u0003s\u0001\u0012\u0011!a\u0001\u0003[\ta!Z9vC2\u001cH\u0003BA(\u0003CB\u0001\"!\u000f\u0012\u0003\u0003\u0005\ra\u001e\u0015\u0014\u0001\u0005\u0015\u00141NA7\u0003c\n\u0019(a\u001e\u0002z\u0005u\u0014q\u0010\t\u0004S\u0005\u001d\u0014bAA55\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA8\u0003\u0005\u001d!\u0002\t\u0011!A}3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!KN$\u0018.\\1uK\u0012\u0004c.^7cKJ\u0004sN\u001a\u0011v]&\fX/\u001a\u0011wC2,Xm\u001d\u0011hSZ,g\u000e\t;iK\u0002\u0012\u0017N\\1ss\u0002\u0012X\r\u001d:fg\u0016tG/\u0019;j_:T\u0001\u0005\t\u0011!_\u001a\u0004\u0013\r\t#bi\u0006\u001c8.\u001a;dQ\u0016\u001c\b\u0005\u00137m'.,Go\u00195/A\u0005AQ\r_1na2,7/\t\u0002\u0002v\u0005\u0019(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b5mY~\u001b8.\u001a;dQ~\u000bwm\u001a\u0015d_2L\u0013\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&M\u0015-A!\n\u0014\u0006\f\u0011)e%b\u0003\u0005\u000b\u001a*Y\u0001B3'\u000b\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005m\u0014AC7jg\u000e|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011\u0011Q\u0001\u0006g9*d\u0006M\u0001\u0012\u00112d7k[3uG\",5\u000f^5nCR,\u0007CA\u0015\u0014'\u0015\u0019\u0012\u0011RAK!\u0019\tY)!%P+6\u0011\u0011Q\u0012\u0006\u0004\u0003\u001fs\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003'\u000biIA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!a&\u0002\u001e6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000b\u0019#\u0001\u0002j_&\u00191*!'\u0015\u0005\u0005\u0015\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0011!B1qa2LHcA+\u0002*\")QJ\u0006a\u0001\u001f\u00069QO\\1qa2LH\u0003BAX\u0003k\u0003B!PAY\u001f&\u0019\u00111\u0017 \u0003\r=\u0003H/[8o\u0011!\t9lFA\u0001\u0002\u0004)\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011Q\u0018\t\u0005\u0003;\ty,\u0003\u0003\u0002B\u0006}!AB(cU\u0016\u001cG\u000f")
public class HllSketchEstimate
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(HllSketchEstimate x$0) {
        return HllSketchEstimate$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<HllSketchEstimate, A> g) {
        return HllSketchEstimate$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, HllSketchEstimate> compose(Function1<A$, Expression> g) {
        return HllSketchEstimate$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public HllSketchEstimate withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    @Override
    public String prettyName() {
        return "hll_sketch_estimate";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BinaryType$[]{BinaryType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object input) {
        Long l;
        byte[] buffer = (byte[])input;
        try {
            l = BoxesRunTime.boxToLong((long)Math.round(HllSketch.heapify((Memory)Memory.wrap((byte[])buffer)).getEstimate()));
        }
        catch (Error error) {
            throw QueryExecutionErrors$.MODULE$.hllInvalidInputSketchBuffer(this.prettyName());
        }
        return l;
    }

    public HllSketchEstimate copy(Expression child) {
        return new HllSketchEstimate(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "HllSketchEstimate";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HllSketchEstimate;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HllSketchEstimate)) return false;
        boolean bl = true;
        if (!bl) return false;
        HllSketchEstimate hllSketchEstimate = (HllSketchEstimate)x$1;
        Expression expression = this.child();
        Expression expression2 = hllSketchEstimate.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!hllSketchEstimate.canEqual(this)) return false;
        return true;
    }

    public HllSketchEstimate(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

