/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.connector.expressions.BucketTransform;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.NamedTransform$;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SparkSchemaUtils$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

public final class SchemaUtils$ {
    public static final SchemaUtils$ MODULE$ = new SchemaUtils$();

    public void checkSchemaColumnNameDuplication(DataType schema, boolean caseSensitiveAnalysis) {
        DataType dataType;
        while (true) {
            if ((dataType = schema) instanceof ArrayType) {
                DataType elementType;
                ArrayType arrayType = (ArrayType)dataType;
                schema = elementType = arrayType.elementType();
                continue;
            }
            if (!(dataType instanceof MapType)) break;
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            this.checkSchemaColumnNameDuplication(keyType, caseSensitiveAnalysis);
            schema = valueType;
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            this.checkColumnNameDuplication((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$1 -> x$1.name(), ClassTag$.MODULE$.apply(String.class))), caseSensitiveAnalysis);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> {
                SchemaUtils$.MODULE$.checkSchemaColumnNameDuplication(field.dataType(), caseSensitiveAnalysis);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void checkSchemaColumnNameDuplication(StructType schema, Function2<String, String, Object> resolver) {
        this.checkSchemaColumnNameDuplication((DataType)schema, this.isCaseSensitiveAnalysis(resolver));
    }

    public boolean checkSchemaColumnNameDuplication$default$2() {
        return false;
    }

    private boolean isCaseSensitiveAnalysis(Function2<String, String, Object> resolver) {
        boolean bl;
        Function2<String, String, Object> function2 = resolver;
        Function2<String, String, Object> function22 = package$.MODULE$.caseSensitiveResolution();
        if (!(function2 != null ? !function2.equals(function22) : function22 != null)) {
            bl = true;
        } else {
            Function2<String, String, Object> function23 = resolver;
            Function2<String, String, Object> function24 = package$.MODULE$.caseInsensitiveResolution();
            if (!(function23 != null ? !function23.equals(function24) : function24 != null)) {
                bl = false;
            } else {
                throw QueryExecutionErrors$.MODULE$.unreachableError(": A resolver to check if two identifiers are equal must be `caseSensitiveResolution` or `caseInsensitiveResolution` in o.a.s.sql.catalyst.");
            }
        }
        return bl;
    }

    public void checkColumnNameDuplication(Seq<String> columnNames, Function2<String, String, Object> resolver) {
        this.checkColumnNameDuplication(columnNames, this.isCaseSensitiveAnalysis(resolver));
    }

    public void checkColumnNameDuplication(Seq<String> columnNames, boolean caseSensitiveAnalysis) {
        Seq names;
        Seq seq = names = caseSensitiveAnalysis ? columnNames : (Seq)columnNames.map((Function1 & Serializable)x$2 -> x$2.toLowerCase());
        if (((SeqOps)names.distinct()).length() != names.length()) {
            String columnName = (String)((IterableOnceOps)names.groupBy((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).toSeq().sortBy((Function1 & Serializable)x$3 -> (String)x$3._1(), (Ordering)Ordering.String$.MODULE$)).collectFirst((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, Seq<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String x = (String)A1._1();
                        Seq ys = (Seq)A1._2();
                        if (ys.length() > 1) {
                            object = x;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, Seq<String>> x1) {
                    Seq ys;
                    Tuple2<String, Seq<String>> tuple2 = x1;
                    boolean bl = tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
                    return bl;
                }
            }).get();
            throw QueryCompilationErrors$.MODULE$.columnAlreadyExistsError(columnName);
        }
    }

    public Seq<String> explodeNestedFieldNames(StructType schema) {
        return (Seq)this.explode$1(schema).map((Function1 & Serializable)x$6 -> new UnresolvedAttribute((Seq<String>)x$6).name());
    }

    public void checkTransformDuplication(Seq<Transform> transforms, String checkType, boolean isCaseSensitive) {
        Seq normalizedTransforms;
        Seq extractedTransforms = (Seq)transforms.map((Function1 & Serializable)x0$1 -> {
            Some<Tuple2<String, Seq<Expression>>> some;
            Tuple2 tuple2;
            Transform transform2 = x0$1;
            if (transform2 instanceof BucketTransform) {
                BucketTransform bucketTransform = (BucketTransform)transform2;
                Seq colNames = (Seq)bucketTransform.columns().map((Function1 & Serializable)c -> new UnresolvedAttribute((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)c.fieldNames())).name());
                MODULE$.checkColumnNameDuplication((Seq<String>)colNames, isCaseSensitive);
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bucketTransform.name()), (Object)colNames);
            } else if (transform2 != null && !(some = NamedTransform$.MODULE$.unapply(transform2)).isEmpty()) {
                String transformName = (String)((Tuple2)some.get())._1();
                Seq refs = (Seq)((Tuple2)some.get())._2();
                Seq fieldNameParts = (Seq)refs.collect((PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof FieldReference) {
                            FieldReference fieldReference = (FieldReference)A1;
                            Seq<String> parts = fieldReference.parts();
                            object = new UnresolvedAttribute(parts).name();
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Expression x1) {
                        Expression expression = x1;
                        boolean bl = expression instanceof FieldReference;
                        return bl;
                    }
                });
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transformName), (Object)fieldNameParts);
            } else {
                throw new MatchError((Object)transform2);
            }
            return tuple2;
        });
        Seq seq = normalizedTransforms = isCaseSensitive ? extractedTransforms : (Seq)extractedTransforms.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t._1()), ((IterableOps)t._2()).map((Function1 & Serializable)x$7 -> x$7.toLowerCase(Locale.ROOT))));
        if (((SeqOps)normalizedTransforms.distinct()).length() != normalizedTransforms.length()) {
            Iterable duplicateColumns = (Iterable)normalizedTransforms.groupBy((Function1 & Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x)).collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Tuple2<String, Seq<String>>, Seq<Tuple2<String, Seq<String>>>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 != null) {
                        Tuple2 x = (Tuple2)A1._1();
                        Seq ys = (Seq)A1._2();
                        if (ys.length() > 1) {
                            object = String.valueOf(((IterableOnceOps)x._2()).mkString("."));
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<Tuple2<String, Seq<String>>, Seq<Tuple2<String, Seq<String>>>> x2) {
                    Seq ys;
                    Tuple2<Tuple2<String, Seq<String>>, Seq<Tuple2<String, Seq<String>>>> tuple2 = x2;
                    boolean bl = tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
                    return bl;
                }
            });
            throw new AnalysisException(new StringBuilder(28).append("Found duplicate column(s) ").append(checkType).append(": ").append(duplicateColumns.mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
    }

    public Seq<Object> findColumnPosition(Seq<String> column, StructType schema, Function2<String, String, Object> resolver) {
        Seq seq;
        try {
            seq = SchemaUtils$.find$1(column, schema, (Seq)scala.package$.MODULE$.Nil(), resolver);
        }
        catch (IndexOutOfBoundsException i) {
            throw new AnalysisException(new StringBuilder(26).append("Couldn't find column ").append(i.getMessage()).append(" in:\n").append(schema.treeString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        catch (AnalysisException e) {
            throw new AnalysisException(new StringBuilder(0).append(e.getMessage()).append(new StringBuilder(2).append(":\n").append(schema.treeString()).toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        return seq;
    }

    public Seq<String> getColumnName(Seq<Object> position, StructType schema) {
        StructField topLevel = schema.apply(BoxesRunTime.unboxToInt((Object)position.head()));
        Tuple2 field = (Tuple2)((IterableOnceOps)position.tail()).foldLeft((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topLevel.name()}))), (Object)topLevel), (Function2 & Serializable)(x0$1, x1$1) -> SchemaUtils$.$anonfun$getColumnName$1(schema, x0$1, BoxesRunTime.unboxToInt((Object)x1$1)));
        return (Seq)field._1();
    }

    public Seq<NamedExpression> restoreOriginalOutputNames(Seq<NamedExpression> projectList, Seq<String> originalNames) {
        return (Seq)((IterableOps)projectList.zip(originalNames)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                NamedExpression attr = (NamedExpression)tuple2._1();
                String name = (String)tuple2._2();
                if (attr instanceof Attribute) {
                    Attribute attribute = (Attribute)attr;
                    return attribute.withName(name);
                }
            }
            if (tuple2 != null) {
                NamedExpression alias = (NamedExpression)tuple2._1();
                String name = (String)tuple2._2();
                if (alias instanceof Alias) {
                    Alias alias2 = (Alias)alias;
                    return alias2.withName(name);
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            NamedExpression other = (NamedExpression)tuple2._1();
            return other;
        });
    }

    public String escapeMetaCharacters(String str) {
        return SparkSchemaUtils$.MODULE$.escapeMetaCharacters(str);
    }

    private final Seq recurseIntoComplexTypes$1(DataType complexType) {
        Seq seq;
        block4: {
            DataType dataType;
            while (true) {
                if ((dataType = complexType) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    seq = this.explode$1(structType);
                    break block4;
                }
                if (!(dataType instanceof ArrayType)) break;
                ArrayType arrayType = (ArrayType)dataType;
                complexType = arrayType.elementType();
            }
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                seq = (Seq)((IterableOps)this.recurseIntoComplexTypes$1(mapType.keyType()).map((Function1 & Serializable)x$4 -> (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).$plus$plus((IterableOnce)x$4))).$plus$plus((IterableOnce)this.recurseIntoComplexTypes$1(mapType.valueType()).map((Function1 & Serializable)x$5 -> (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"})).$plus$plus((IterableOnce)x$5)));
            } else {
                seq = scala.package$.MODULE$.Nil();
            }
        }
        return seq;
    }

    private final Seq explode$1(StructType schema) {
        return (Seq)schema.flatMap((Function1 & Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                String name = structField.name();
                DataType s = structField.dataType();
                if (s instanceof StructType) {
                    StructType structType = (StructType)s;
                    return (IterableOnce)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name}))})).$plus$plus((IterableOnce)this.explode$1(structType).map((Function1 & Serializable)nested -> (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name})).$plus$plus((IterableOnce)nested)));
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType a = structField.dataType();
                if (a instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)a;
                    return (IterableOnce)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name}))})).$plus$plus((IterableOnce)this.recurseIntoComplexTypes$1((DataType)arrayType).map((Function1 & Serializable)nested -> (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name})).$plus$plus((IterableOnce)nested)));
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType m = structField.dataType();
                if (m instanceof MapType) {
                    MapType mapType = (MapType)m;
                    return (IterableOnce)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name}))})).$plus$plus((IterableOnce)this.recurseIntoComplexTypes$1((DataType)mapType).map((Function1 & Serializable)nested -> (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name})).$plus$plus((IterableOnce)nested)));
                }
            }
            Seq seq = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{structField.name()}));
            return scala.package$.MODULE$.Nil().$colon$colon((Object)seq);
        });
    }

    private static final /* synthetic */ String columnPath$lzycompute$1(LazyRef columnPath$lzy$1, Seq stack$1, String thisCol$1) {
        String string;
        LazyRef lazyRef = columnPath$lzy$1;
        synchronized (lazyRef) {
            string = columnPath$lzy$1.initialized() ? (String)columnPath$lzy$1.value() : (String)columnPath$lzy$1.initialize((Object)new UnresolvedAttribute((Seq<String>)((Seq)stack$1.$colon$plus((Object)thisCol$1))).name());
        }
        return string;
    }

    private static final String columnPath$1(LazyRef columnPath$lzy$1, Seq stack$1, String thisCol$1) {
        return columnPath$lzy$1.initialized() ? (String)columnPath$lzy$1.value() : SchemaUtils$.columnPath$lzycompute$1(columnPath$lzy$1, stack$1, thisCol$1);
    }

    public static final /* synthetic */ boolean $anonfun$findColumnPosition$1(Function2 resolver$1, String thisCol$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)thisCol$1));
    }

    private static final Seq find$1(Seq column, StructType schema, Seq stack, Function2 resolver$1) {
        ArrayType arrayType;
        DataType s;
        Nil$ nil$;
        LazyRef columnPath$lzy = new LazyRef();
        if (column.isEmpty()) {
            return scala.package$.MODULE$.Nil();
        }
        String thisCol = (String)column.head();
        int pos = schema.indexWhere((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$findColumnPosition$1(resolver$1, thisCol, f)));
        if (pos == -1) {
            throw new IndexOutOfBoundsException(SchemaUtils$.columnPath$1(columnPath$lzy, stack, thisCol));
        }
        DataType dataType = schema.apply(pos).dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            nil$ = SchemaUtils$.find$1((Seq)column.tail(), structType, (Seq)stack.$colon$plus((Object)thisCol), resolver$1);
        } else if (dataType instanceof ArrayType && (s = (arrayType = (ArrayType)dataType).elementType()) instanceof StructType) {
            StructType structType = (StructType)s;
            nil$ = SchemaUtils$.find$1((Seq)column.tail(), structType, (Seq)stack.$colon$plus((Object)thisCol), resolver$1);
        } else {
            if (column.length() > 1) {
                throw new AnalysisException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(128).append("Expected ").append(SchemaUtils$.columnPath$1(columnPath$lzy, stack, thisCol)).append(" to be a nested data type, but found ").append(dataType).append(". Was looking for the\n                 |index of ").append(new UnresolvedAttribute((Seq<String>)column).name()).append(" in a nested field\n              ").toString())), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
            }
            nil$ = scala.package$.MODULE$.Nil();
        }
        Nil$ children2 = nil$;
        return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{pos})).$plus$plus((IterableOnce)children2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Tuple2 $anonfun$getColumnName$1(StructType schema$1, Tuple2 x0$1, int x1$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        Tuple2 nameAndField = (Tuple2)tuple22._1();
        int pos = tuple22._2$mcI$sp();
        DataType dataType = ((StructField)nameAndField._2()).dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField nowField = structType.apply(pos);
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((SeqOps)nameAndField._1()).$colon$plus((Object)nowField.name())), (Object)nowField);
            return tuple2;
        } else {
            if (!(dataType instanceof ArrayType)) throw new AnalysisException(new StringBuilder(49).append("The positions provided (").append(pos).append(") cannot be resolved in\n").append(schema$1.treeString()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
            ArrayType arrayType = (ArrayType)dataType;
            DataType s = arrayType.elementType();
            if (!(s instanceof StructType)) throw new AnalysisException(new StringBuilder(49).append("The positions provided (").append(pos).append(") cannot be resolved in\n").append(schema$1.treeString()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
            StructType structType = (StructType)s;
            StructField nowField = structType.apply(pos);
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((SeqOps)nameAndField._1()).$colon$plus((Object)nowField.name())), (Object)nowField);
        }
        return tuple2;
    }

    private SchemaUtils$() {
    }
}

