/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.TimeTravelSpec$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SessionConfigSupport;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;

public final class DataSourceV2Utils$
implements Logging {
    public static final DataSourceV2Utils$ MODULE$ = new DataSourceV2Utils$();
    private static ObjectMapper objectMapper;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public scala.collection.immutable.Map<String, String> extractSessionConfigs(TableProvider source, SQLConf conf) {
        scala.collection.immutable.Map map;
        TableProvider tableProvider = source;
        if (tableProvider instanceof SessionConfigSupport) {
            SessionConfigSupport sessionConfigSupport = (SessionConfigSupport)tableProvider;
            String keyPrefix = sessionConfigSupport.keyPrefix();
            Predef$.MODULE$.require(keyPrefix != null, (Function0 & Serializable)() -> "The data source config key prefix can't be null.");
            Pattern pattern = Pattern.compile(new StringBuilder(26).append("^spark\\.datasource\\.").append(keyPrefix).append("\\.(.+)").toString());
            map = (scala.collection.immutable.Map)conf.getAllConfs().flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                Matcher m = pattern.matcher(key);
                SeqOps seqOps = m.matches() && m.groupCount() > 0 ? package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)m.group(1), (Object)value)})) : package$.MODULE$.Seq().empty();
                return seqOps;
            });
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public Table getTableFromProvider(TableProvider provider, CaseInsensitiveStringMap options, Option<StructType> userSpecifiedSchema) {
        Table table;
        Option<StructType> option = userSpecifiedSchema;
        if (option instanceof Some) {
            Some some = (Some)option;
            StructType schema = (StructType)some.value();
            if (!provider.supportsExternalMetadata()) {
                throw QueryExecutionErrors$.MODULE$.userSpecifiedSchemaUnsupportedByDataSourceError(provider);
            }
            table = provider.getTable(schema, provider.inferPartitioning(options), options.asCaseSensitiveMap());
        } else if (None$.MODULE$.equals(option)) {
            table = provider.getTable(provider.inferSchema(options), provider.inferPartitioning(options), options.asCaseSensitiveMap());
        } else {
            throw new MatchError(option);
        }
        return table;
    }

    public Option<Dataset<Row>> loadV2Source(SparkSession sparkSession, TableProvider provider, Option<StructType> userSpecifiedSchema, CaseInsensitiveMap<String> extraOptions, String source, Seq<String> paths) {
        Tuple3 tuple3;
        CatalogManager catalogManager = sparkSession.sessionState().catalogManager();
        SQLConf conf = sparkSession.sessionState().conf();
        scala.collection.immutable.Map<String, String> sessionOptions = this.extractSessionConfigs(provider, conf);
        CaseInsensitiveMap<String> optionsWithPath = this.getOptionsWithPaths(extraOptions, paths);
        scala.collection.immutable.Map finalOptions = (scala.collection.immutable.Map)sessionOptions.filterKeys((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2Utils$.$anonfun$loadV2Source$1(optionsWithPath, x$1))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)optionsWithPath.originalMap());
        CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)finalOptions).asJava());
        boolean bl = false;
        SupportsCatalogOptions supportsCatalogOptions = null;
        TableProvider tableProvider = provider;
        if (tableProvider instanceof SupportsCatalogOptions) {
            bl = true;
            supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
            if (userSpecifiedSchema.nonEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(73).append(source).append(" does not support user specified schema. Please don't specify the schema.").toString());
            }
        }
        if (bl) {
            None$ timeTravelVersion;
            Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
            TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
            Optional version = supportsCatalogOptions.extractTimeTravelVersion(dsOptions);
            Optional timestamp = supportsCatalogOptions.extractTimeTravelTimestamp(dsOptions);
            Object object = timeTravelVersion = version.isPresent() ? new Some(version.get()) : None$.MODULE$;
            None$ timeTravelTimestamp = timestamp.isPresent() ? (StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString((String)timestamp.get()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$2))))) ? new Some((Object)new Literal((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)timestamp.get()))), (DataType)LongType$.MODULE$)) : new Some((Object)Literal$.MODULE$.apply(timestamp.get()))) : None$.MODULE$;
            Option timeTravel = TimeTravelSpec$.MODULE$.create((Option)timeTravelTimestamp, (Option)timeTravelVersion, conf);
            tuple3 = new Tuple3((Object)CatalogV2Util$.MODULE$.getTable((CatalogPlugin)catalog, ident, timeTravel, CatalogV2Util$.MODULE$.getTable$default$4()), (Object)new Some((Object)catalog), (Object)new Some((Object)ident));
        } else {
            Table tbl = this.getTableFromProvider(provider, dsOptions, userSpecifiedSchema);
            tuple3 = new Tuple3((Object)tbl, (Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        Tuple3 tuple32 = tuple3;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        Table table = (Table)tuple32._1();
        Option catalog = (Option)tuple32._2();
        Option ident = (Option)tuple32._3();
        Tuple3 tuple33 = new Tuple3((Object)table, (Object)catalog, (Object)ident);
        Tuple3 tuple34 = tuple33;
        Table table2 = (Table)tuple34._1();
        Option catalog2 = (Option)tuple34._2();
        Option ident2 = (Option)tuple34._3();
        Table table3 = table2;
        Object object = table3 instanceof SupportsRead && DataSourceV2Implicits$.MODULE$.TableHelper(table2).supports(TableCapability.BATCH_READ) ? Option$.MODULE$.apply(Dataset$.MODULE$.ofRows(sparkSession, (LogicalPlan)DataSourceV2Relation$.MODULE$.create(table2, catalog2, ident2, dsOptions))) : None$.MODULE$;
        return object;
    }

    private ObjectMapper objectMapper$lzycompute() {
        DataSourceV2Utils$ dataSourceV2Utils$ = this;
        synchronized (dataSourceV2Utils$) {
            if (!bitmap$0) {
                objectMapper = new ObjectMapper();
                bitmap$0 = true;
            }
        }
        return objectMapper;
    }

    private ObjectMapper objectMapper() {
        return !bitmap$0 ? this.objectMapper$lzycompute() : objectMapper;
    }

    private CaseInsensitiveMap<String> getOptionsWithPaths(CaseInsensitiveMap<String> extraOptions, Seq<String> paths) {
        return paths.isEmpty() ? extraOptions : (paths.length() == 1 ? extraOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), paths.head())) : extraOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paths"), (Object)this.objectMapper().writeValueAsString(paths.toArray(ClassTag$.MODULE$.apply(String.class))))));
    }

    public static final /* synthetic */ boolean $anonfun$loadV2Source$1(CaseInsensitiveMap optionsWithPath$1, String x$1) {
        return !optionsWithPath$1.contains(x$1);
    }

    private DataSourceV2Utils$() {
    }
}

