/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.model.core.sso.SingleSignOnProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.RegisteredServiceTicketGrantingTicketExpirationPolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicketAwareTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.model.TriStateBoolean;
import org.apereo.cas.web.flow.BaseSingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSingleSignOnParticipationStrategy
extends BaseSingleSignOnParticipationStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSingleSignOnParticipationStrategy.class);
    private final SingleSignOnProperties properties;
    private int order = Integer.MAX_VALUE;

    public DefaultSingleSignOnParticipationStrategy(ServicesManager servicesManager, SingleSignOnProperties properties, TicketRegistrySupport ticketRegistrySupport, AuthenticationServiceSelectionPlan serviceSelectionStrategy) {
        super(servicesManager, ticketRegistrySupport, serviceSelectionStrategy);
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParticipating(SingleSignOnParticipationRequest ssoRequest) {
        if (this.properties.isRenewAuthnEnabled() && ssoRequest.isRequestingRenewAuthentication()) {
            LOGGER.debug("The authentication session is considered renewed.");
            return false;
        }
        WebBasedRegisteredService registeredService = (WebBasedRegisteredService)this.getRegisteredService(ssoRequest);
        if (registeredService == null) {
            return this.properties.isSsoEnabled();
        }
        Authentication authentication = DefaultSingleSignOnParticipationStrategy.getAuthenticationFrom(ssoRequest);
        Authentication ca = AuthenticationCredentialsThreadLocalBinder.getCurrentAuthentication();
        try {
            Optional<Ticket> ticketState;
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authentication);
            boolean isAllowedForSso = registeredService.getAccessStrategy().isServiceAccessAllowedForSso();
            LOGGER.trace("Located [{}] in registry. Service access to participate in SSO is set to [{}]", (Object)registeredService.getServiceId(), (Object)isAllowedForSso);
            if (!isAllowedForSso) {
                LOGGER.debug("Service [{}] is not authorized to participate in SSO", (Object)registeredService.getServiceId());
                boolean bl = false;
                return bl;
            }
            RegisteredServiceSingleSignOnParticipationPolicy ssoPolicy = registeredService.getSingleSignOnParticipationPolicy();
            if (ssoPolicy != null && (ticketState = this.getTicketState(ssoRequest)).isPresent()) {
                boolean bl = ssoPolicy.shouldParticipateInSso((RegisteredService)registeredService, (AuthenticationAwareTicket)ticketState.get());
                return bl;
            }
            RegisteredServiceTicketGrantingTicketExpirationPolicy tgtPolicy = registeredService.getTicketGrantingTicketExpirationPolicy();
            if (tgtPolicy != null) {
                Optional<Ticket> ticketState2 = this.getTicketState(ssoRequest);
                boolean bl = tgtPolicy.toExpirationPolicy().filter(tgt -> ticketState2.isPresent()).map(policy -> !policy.isExpired((TicketGrantingTicketAwareTicket)ticketState2.get())).orElse(Boolean.TRUE);
                return bl;
            }
        }
        finally {
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)ca);
        }
        return this.properties.isSsoEnabled();
    }

    public TriStateBoolean isCreateCookieOnRenewedAuthentication(SingleSignOnParticipationRequest context) {
        RegisteredServiceSingleSignOnParticipationPolicy ssoPolicy;
        WebBasedRegisteredService registeredService = (WebBasedRegisteredService)this.getRegisteredService(context);
        if (registeredService != null && (ssoPolicy = registeredService.getSingleSignOnParticipationPolicy()) != null) {
            return ssoPolicy.getCreateCookieOnRenewedAuthentication();
        }
        return TriStateBoolean.fromBoolean((boolean)this.properties.isCreateSsoCookieOnRenewAuthn());
    }

    @Generated
    public SingleSignOnProperties getProperties() {
        return this.properties;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

