/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.revocation.checker;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.CRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.ResourceCRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.AbstractCRLRevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.RevocationPolicy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CertUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.GeneralName;
import org.cryptacular.x509.ExtensionReader;
import org.ehcache.Status;
import org.ehcache.UserManagedCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class CRLDistributionPointRevocationChecker
extends AbstractCRLRevocationChecker
implements DisposableBean,
AutoCloseable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CRLDistributionPointRevocationChecker.class);
    private final UserManagedCache<URI, byte[]> crlCache;
    private final CRLFetcher fetcher;
    private final boolean throwOnFetchFailure;

    public CRLDistributionPointRevocationChecker(UserManagedCache<URI, byte[]> crlCache, CRLFetcher fetcher, boolean throwOnFetchFailure) {
        this(false, null, null, crlCache, fetcher, throwOnFetchFailure);
    }

    public CRLDistributionPointRevocationChecker(UserManagedCache<URI, byte[]> crlCache, RevocationPolicy<X509CRL> expiredCRLPolicy, RevocationPolicy<Void> unavailableCRLPolicy) {
        this(crlCache, expiredCRLPolicy, unavailableCRLPolicy, false);
    }

    public CRLDistributionPointRevocationChecker(UserManagedCache<URI, byte[]> crlCache, RevocationPolicy<X509CRL> expiredCRLPolicy, RevocationPolicy<Void> unavailableCRLPolicy, boolean throwOnFetchFailure) {
        this(false, unavailableCRLPolicy, expiredCRLPolicy, crlCache, new ResourceCRLFetcher(), throwOnFetchFailure);
    }

    public CRLDistributionPointRevocationChecker(boolean checkAll, RevocationPolicy<Void> unavailableCRLPolicy, RevocationPolicy<X509CRL> expiredCRLPolicy, UserManagedCache<URI, byte[]> crlCache, CRLFetcher fetcher, boolean throwOnFetchFailure) {
        super(checkAll, unavailableCRLPolicy, expiredCRLPolicy);
        this.crlCache = crlCache;
        if (Status.UNINITIALIZED.equals((Object)this.crlCache.getStatus())) {
            this.crlCache.init();
        }
        this.fetcher = fetcher;
        this.throwOnFetchFailure = throwOnFetchFailure;
    }

    public void destroy() {
        try {
            if (!Status.UNINITIALIZED.equals((Object)this.crlCache.getStatus())) {
                this.crlCache.close();
            }
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.destroy();
    }

    private static URI[] getDistributionPoints(X509Certificate cert) {
        try {
            List points = new ExtensionReader(cert).readCRLDistributionPoints();
            ArrayList urls = new ArrayList(points == null ? 0 : points.size());
            if (points != null) {
                points.stream().map(DistributionPoint::getDistributionPoint).filter(Objects::nonNull).forEach(pointName -> {
                    ASN1Sequence nameSequence = ASN1Sequence.getInstance((Object)pointName.getName());
                    IntStream.range(0, nameSequence.size()).mapToObj(i -> GeneralName.getInstance((Object)nameSequence.getObjectAt(i))).forEach(name -> {
                        LOGGER.debug("Found CRL distribution point [{}].", name);
                        try {
                            CRLDistributionPointRevocationChecker.addURL(urls, DERIA5String.getInstance((Object)name.getName()).getString());
                        }
                        catch (Exception e) {
                            LOGGER.warn("[{}] not supported: [{}].", pointName, (Object)e.getMessage());
                        }
                    });
                });
            }
            return (URI[])urls.toArray(URI[]::new);
        }
        catch (Exception e) {
            LOGGER.debug("Error reading CRLDistributionPoints extension field on [{}]", (Object)CertUtils.toString((X509Certificate)cert));
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return new URI[0];
        }
    }

    private static void addURL(List<URI> list, String uriString) {
        try {
            try {
                URL url = new URL(URLDecoder.decode(uriString, StandardCharsets.UTF_8.name()));
                list.add(new URI(url.getProtocol(), url.getAuthority(), url.getPath(), url.getQuery(), null));
            }
            catch (MalformedURLException e) {
                list.add(new URI(uriString));
            }
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
        }
    }

    private boolean addCRLbyURI(URI uri, X509CRL crl) {
        return this.addCRL(uri, crl);
    }

    protected List<X509CRL> getCRLs(X509Certificate cert) {
        URI[] urls = CRLDistributionPointRevocationChecker.getDistributionPoints(cert);
        LOGGER.debug("Distribution points for [{}]: [{}].", (Object)CertUtils.toString((X509Certificate)cert), (Object)CollectionUtils.wrap((Object)urls));
        ArrayList<X509CRL> listOfLocations = new ArrayList<X509CRL>(urls.length);
        boolean stopFetching = false;
        for (int index = 0; !stopFetching && index < urls.length; ++index) {
            block8: {
                URI url = urls[index];
                byte[] item = (byte[])this.crlCache.get((Object)url);
                if (item != null) {
                    LOGGER.debug("Found CRL in cache for [{}]", (Object)CertUtils.toString((X509Certificate)cert));
                    X509CRL crlFetched = (X509CRL)FunctionUtils.doUnchecked(() -> this.fetcher.fetch((Resource)new ByteArrayResource(item)));
                    if (crlFetched != null) {
                        listOfLocations.add(crlFetched);
                    } else {
                        LOGGER.warn("Could fetch X509 CRL for [{}]. Returned value is null", (Object)url);
                    }
                } else {
                    LOGGER.debug("CRL for [{}] is not cached. Fetching and caching...", (Object)CertUtils.toString((X509Certificate)cert));
                    try {
                        X509CRL crl = this.fetcher.fetch(url);
                        if (crl != null) {
                            LOGGER.info("Success. Caching fetched CRL at [{}].", (Object)url);
                            this.addCRLbyURI(url, crl);
                            listOfLocations.add(crl);
                        }
                    }
                    catch (Exception e) {
                        LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                        if (!this.throwOnFetchFailure) break block8;
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            }
            if (this.checkAll || listOfLocations.isEmpty()) continue;
            LOGGER.debug("CRL fetching is configured to not check all locations.");
            stopFetching = true;
        }
        LOGGER.debug("Found [{}] CRLs", (Object)listOfLocations.size());
        return listOfLocations;
    }

    @Override
    protected boolean addCRL(Object id, X509CRL crl) {
        return (Boolean)FunctionUtils.doUnchecked(() -> {
            URI uri = (URI)id;
            if (crl == null) {
                LOGGER.debug("No CRL was passed. Removing [{}] from cache...", id);
                this.crlCache.remove((Object)uri);
                return false;
            }
            this.crlCache.put((Object)uri, (Object)crl.getEncoded());
            return this.crlCache.containsKey((Object)uri);
        });
    }
}

