/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels.search;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggle;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggleConfig;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.RelationshipTypeRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxEventBehavior;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.SchemaUtils;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.common.lib.search.GroupCompleteCondition;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.springframework.util.CollectionUtils;

public class SearchClausePanel
extends FieldPanel<SearchClause> {
    private static final long serialVersionUID = -527351923968737757L;
    protected static final AttributeModifier PREVENT_DEFAULT_RETURN = AttributeModifier.replace((String)"onkeydown", (IModel)Model.of((Serializable)((Object)"if (event.keyCode == 13) { event.preventDefault(); }")));
    protected static final Consumer<AjaxRequestAttributes> AJAX_SUBMIT_ON_RETURN = attributes -> attributes.getAjaxCallListeners().add(new AjaxCallListener(){
        private static final long serialVersionUID = 7160235486520935153L;

        public CharSequence getPrecondition(Component component) {
            return "return (Wicket.Event.keyCode(attrs.event) == 13);";
        }
    });
    @SpringBean
    protected RelationshipTypeRestClient relationshipTypeRestClient;
    @SpringBean
    protected GroupRestClient groupRestClient;
    protected final boolean required;
    protected final IModel<List<SearchClause.Type>> types;
    protected final Customizer customizer;
    protected final IModel<Map<String, PlainSchemaTO>> anames;
    protected final IModel<Map<String, PlainSchemaTO>> dnames;
    protected final Pair<IModel<List<String>>, IModel<Integer>> groupInfo;
    protected final IModel<List<String>> roleNames;
    protected final IModel<List<String>> privilegeNames;
    protected final IModel<List<String>> auxClassNames;
    protected final IModel<List<String>> resourceNames;
    protected IModel<SearchClause> clause;
    protected final LoadableDetachableModel<List<SearchClause.Comparator>> comparators;
    protected final LoadableDetachableModel<List<Pair<String, String>>> properties;
    protected final Fragment operatorFragment;
    protected final Fragment searchButtonFragment;
    protected final AjaxLink<Void> searchButton;
    protected IEventSink resultContainer;
    private FieldPanel<?> value;

    public SearchClausePanel(String id, String name, Model<SearchClause> clause, boolean required, IModel<List<SearchClause.Type>> types, final Customizer customizer, final IModel<Map<String, PlainSchemaTO>> anames, final IModel<Map<String, PlainSchemaTO>> dnames, final Pair<IModel<List<String>>, IModel<Integer>> groupInfo, final IModel<List<String>> roleNames, final IModel<List<String>> privilegeNames, final IModel<List<String>> auxClassNames, final IModel<List<String>> resourceNames) {
        super(id, name, clause);
        this.clause = (IModel)Optional.ofNullable(clause).orElseGet(() -> new Model(null));
        this.required = required;
        this.types = types;
        this.customizer = customizer;
        this.anames = anames;
        this.dnames = dnames;
        this.groupInfo = groupInfo;
        this.roleNames = roleNames;
        this.privilegeNames = privilegeNames;
        this.auxClassNames = auxClassNames;
        this.resourceNames = resourceNames;
        this.searchButton = new AjaxLink<Void>("search"){
            private static final long serialVersionUID = 5538299138211283825L;

            public void onClick(AjaxRequestTarget target) {
                Optional.ofNullable(SearchClausePanel.this.resultContainer).ifPresentOrElse(container -> this.send((IEventSink)container, Broadcast.EXACT, new SearchEvent(target)), () -> this.send((IEventSink)SearchClausePanel.this, Broadcast.BUBBLE, new SearchEvent(target)));
            }
        };
        this.searchButtonFragment = new Fragment("operator", "searchButtonFragment", (MarkupContainer)this);
        this.searchButtonFragment.add(new Component[]{this.searchButton.setEnabled(false).setVisible(false)});
        this.operatorFragment = new Fragment("operator", "operatorFragment", (MarkupContainer)this);
        this.field = new FormComponent<SearchClause>("container", this.clause){
            private static final long serialVersionUID = -8204140666393922700L;
        };
        this.add(new Component[]{this.field});
        this.comparators = new LoadableDetachableModel<List<SearchClause.Comparator>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<SearchClause.Comparator> load() {
                if (SearchClausePanel.this.field.getModel().getObject() == null || ((SearchClause)SearchClausePanel.this.field.getModel().getObject()).getType() == null) {
                    return List.of();
                }
                switch (((SearchClause)SearchClausePanel.this.field.getModel().getObject()).getType()) {
                    case ATTRIBUTE: {
                        return List.of(SearchClause.Comparator.values());
                    }
                    case GROUP_MEMBERSHIP: 
                    case GROUP_MEMBER: 
                    case AUX_CLASS: 
                    case ROLE_MEMBERSHIP: 
                    case PRIVILEGE: 
                    case RESOURCE: {
                        return List.of(SearchClause.Comparator.EQUALS, SearchClause.Comparator.NOT_EQUALS);
                    }
                    case RELATIONSHIP: {
                        return List.of(SearchClause.Comparator.IS_NOT_NULL, SearchClause.Comparator.IS_NULL, SearchClause.Comparator.EQUALS, SearchClause.Comparator.NOT_EQUALS);
                    }
                    case CUSTOM: {
                        return customizer.comparators();
                    }
                }
                return List.of();
            }
        };
        this.properties = new LoadableDetachableModel<List<Pair<String, String>>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<Pair<String, String>> load() {
                if (SearchClausePanel.this.field.getModel().getObject() == null || ((SearchClause)SearchClausePanel.this.field.getModel().getObject()).getType() == null) {
                    return List.of();
                }
                switch (((SearchClause)SearchClausePanel.this.field.getModel().getObject()).getType()) {
                    case ATTRIBUTE: {
                        Locale locale = SyncopeConsoleSession.get().getLocale();
                        List names = ((Map)dnames.getObject()).entrySet().stream().map(item -> Pair.of((Object)((String)item.getKey()), (Object)Optional.ofNullable(((PlainSchemaTO)item.getValue()).getLabel(locale)).orElse((String)item.getKey()))).collect(Collectors.toList());
                        if (anames != null && !CollectionUtils.isEmpty((Map)((Map)anames.getObject()))) {
                            names.addAll(((Map)anames.getObject()).entrySet().stream().map(item -> Pair.of((Object)((String)item.getKey()), (Object)Optional.ofNullable(((PlainSchemaTO)item.getValue()).getLabel(locale)).orElse((String)item.getKey()))).collect(Collectors.toList()));
                        }
                        return names.stream().sorted(Comparator.comparing(name -> ((String)name.getValue()).toLowerCase())).collect(Collectors.toList());
                    }
                    case GROUP_MEMBERSHIP: {
                        return ((List)((IModel)groupInfo.getLeft()).getObject()).stream().map(item -> Pair.of((Object)item, (Object)item)).collect(Collectors.toList());
                    }
                    case ROLE_MEMBERSHIP: {
                        return Optional.ofNullable(roleNames).map(r -> ((List)r.getObject()).stream().sorted().map(item -> Pair.of((Object)item, (Object)item)).collect(Collectors.toList())).orElse(List.of());
                    }
                    case PRIVILEGE: {
                        return Optional.ofNullable(privilegeNames).map(p -> ((List)p.getObject()).stream().sorted().map(item -> Pair.of((Object)item, (Object)item)).collect(Collectors.toList())).orElse(List.of());
                    }
                    case AUX_CLASS: {
                        return ((List)auxClassNames.getObject()).stream().sorted().map(item -> Pair.of((Object)item, (Object)item)).collect(Collectors.toList());
                    }
                    case RESOURCE: {
                        return ((List)resourceNames.getObject()).stream().sorted().map(item -> Pair.of((Object)item, (Object)item)).collect(Collectors.toList());
                    }
                    case RELATIONSHIP: {
                        return SearchClausePanel.this.relationshipTypeRestClient.list().stream().map(item -> Pair.of((Object)item.getKey(), (Object)item.getKey())).sorted().collect(Collectors.toList());
                    }
                    case CUSTOM: {
                        return customizer.properties().stream().map(item -> Pair.of((Object)item, (Object)item)).collect(Collectors.toList());
                    }
                }
                return List.of();
            }
        };
    }

    public void enableSearch(final IEventSink resultContainer) {
        this.resultContainer = resultContainer;
        this.searchButton.setEnabled(true);
        this.searchButton.setVisible(true);
        this.field.add(new Behavior[]{PREVENT_DEFAULT_RETURN});
        this.field.add(new Behavior[]{new AjaxEventBehavior("keydown"){
            private static final long serialVersionUID = -7133385027739964990L;

            protected void onEvent(AjaxRequestTarget target) {
                if (resultContainer == null) {
                    SearchClausePanel.this.send((IEventSink)SearchClausePanel.this, Broadcast.BUBBLE, new SearchEvent(target));
                } else {
                    SearchClausePanel.this.send(resultContainer, Broadcast.EXACT, new SearchEvent(target));
                }
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AJAX_SUBMIT_ON_RETURN.accept(attributes);
            }
        }});
    }

    public SearchClause getModelObject() {
        return (SearchClause)this.clause.getObject();
    }

    public FieldPanel<SearchClause> setModelObject(SearchClause object) {
        this.clause.setObject((Object)object);
        return super.setModelObject((Serializable)object);
    }

    public FieldPanel<SearchClause> setNewModel(ListItem item) {
        this.clause.setObject((Object)((SearchClause)SearchClause.class.cast(item.getModelObject())));
        return this;
    }

    public FieldPanel<SearchClause> setNewModel(IModel<SearchClause> model) {
        this.clause = model;
        return super.setNewModel(model);
    }

    public FieldPanel<SearchClause> settingsDependingComponents() {
        final SearchClause searchClause = (SearchClause)this.clause.getObject();
        WebMarkupContainer operatorContainer = new WebMarkupContainer("operatorContainer");
        operatorContainer.setOutputMarkupId(true);
        this.field.add(new Component[]{operatorContainer});
        BootstrapToggleConfig config = new BootstrapToggleConfig().withOnStyle(BootstrapToggleConfig.Style.info).withOffStyle(BootstrapToggleConfig.Style.warning).withSize(BootstrapToggleConfig.Size.mini);
        this.operatorFragment.add(new Component[]{new BootstrapToggle("operator", (IModel)new Model<Boolean>(){
            private static final long serialVersionUID = -7157802546272668001L;

            public Boolean getObject() {
                return searchClause.getOperator() == SearchClause.Operator.AND;
            }

            public void setObject(Boolean object) {
                searchClause.setOperator(object != false ? SearchClause.Operator.AND : SearchClause.Operator.OR);
            }
        }, config){
            private static final long serialVersionUID = 2969634208049189343L;

            protected IModel<String> getOffLabel() {
                return Model.of((Serializable)((Object)"OR"));
            }

            protected IModel<String> getOnLabel() {
                return Model.of((Serializable)((Object)"AND"));
            }

            protected CheckBox newCheckBox(String id, IModel<Boolean> model) {
                CheckBox checkBox = super.newCheckBox(id, model);
                checkBox.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                    private static final long serialVersionUID = 18266219802290L;

                    protected void onUpdate(AjaxRequestTarget target) {
                    }
                }});
                return checkBox;
            }
        }.setOutputMarkupPlaceholderTag(true)});
        if (this.getIndex() > 0) {
            operatorContainer.add(new Component[]{this.operatorFragment});
        } else {
            operatorContainer.add(new Component[]{this.searchButtonFragment});
        }
        final AjaxTextFieldPanel property = new AjaxTextFieldPanel("property", "property", (IModel)new PropertyModel((Object)searchClause, "property")){
            private static final long serialVersionUID = -7157802546272668001L;

            protected Optional<IConverter<String>> getConverter() {
                return Optional.of(new IConverter<String>(){
                    private static final long serialVersionUID = -2754107934642211828L;

                    public String convertToObject(String label, Locale locale) throws ConversionException {
                        return ((List)SearchClausePanel.this.properties.getObject()).stream().filter(property -> ((String)property.getValue()).equalsIgnoreCase(label)).findFirst().map(Pair::getKey).orElse(label);
                    }

                    public String convertToString(String key, Locale locale) {
                        return ((List)SearchClausePanel.this.properties.getObject()).stream().filter(property -> ((String)property.getKey()).equalsIgnoreCase(key)).findFirst().map(Pair::getValue).orElse(key);
                    }
                });
            }
        };
        property.setChoices(((List)this.properties.getObject()).stream().map(Pair::getValue).collect(Collectors.toList()));
        this.field.add(new Component[]{property.hideLabel().setOutputMarkupId(true).setEnabled(true)});
        property.getField().add(new Behavior[]{PREVENT_DEFAULT_RETURN});
        property.getField().add(new Behavior[]{new IndicatorAjaxEventBehavior("keyup"){
            private static final long serialVersionUID = -957948639666058749L;

            protected void onEvent(AjaxRequestTarget target) {
                if (SearchClausePanel.this.field.getModel().getObject() != null && ((SearchClause)SearchClausePanel.this.field.getModel().getObject()).getType() == SearchClause.Type.GROUP_MEMBERSHIP) {
                    Object[] inputAsArray = property.getField().getInputAsArray();
                    if (ArrayUtils.isEmpty((Object[])inputAsArray)) {
                        property.setChoices(((List)SearchClausePanel.this.properties.getObject()).stream().map(Pair::getKey).collect(Collectors.toList()));
                    } else if ((Integer)((IModel)SearchClausePanel.this.groupInfo.getRight()).getObject() > 30) {
                        Object inputValue;
                        Object object = inputValue = inputAsArray.length > 1 && inputAsArray[1] != null ? inputAsArray[1] : property.getField().getInput();
                        if (!((String)inputValue).startsWith("*")) {
                            inputValue = "*" + (String)inputValue;
                        }
                        if (!((String)inputValue).endsWith("*")) {
                            inputValue = (String)inputValue + "*";
                        }
                        property.setChoices(SearchClausePanel.this.groupRestClient.search("/", ((GroupCompleteCondition)SyncopeClient.getGroupSearchConditionBuilder().is("name").equalToIgnoreCase((String)inputValue, new String[0])).query(), 1, 30, (SortParam<String>)new SortParam((Object)"name", true), null).stream().map(GroupTO::getName).collect(Collectors.toList()));
                    }
                }
            }
        }});
        property.getField().add(new Behavior[]{new IndicatorAjaxEventBehavior("keydown"){
            private static final long serialVersionUID = -7133385027739964990L;

            protected void onEvent(AjaxRequestTarget target) {
                target.focusComponent(null);
                property.getField().inputChanged();
                property.getField().validate();
                if (property.getField().isValid()) {
                    property.getField().valid();
                    property.getField().updateModel();
                }
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AJAX_SUBMIT_ON_RETURN.accept(attributes);
            }
        }});
        final AjaxDropDownChoicePanel comparator = new AjaxDropDownChoicePanel("comparator", "comparator", (IModel)new PropertyModel((Object)searchClause, "comparator"));
        comparator.setChoices(this.comparators);
        comparator.setNullValid(false).hideLabel().setOutputMarkupId(true);
        comparator.setRequired(this.required);
        comparator.setChoiceRenderer((IChoiceRenderer)new ComparatorRenderer());
        this.field.add(new Component[]{comparator});
        this.value = this.buildValue(searchClause, property);
        this.field.addOrReplace(new Component[]{this.value});
        this.adjust(searchClause.getType(), property, (FieldPanel<SearchClause.Comparator>)comparator);
        property.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                SearchClausePanel.this.value = SearchClausePanel.this.buildValue(searchClause, property);
                SearchClausePanel.this.field.addOrReplace(new Component[]{SearchClausePanel.this.value});
                target.add(new Component[]{SearchClausePanel.this.value});
                SearchClausePanel.this.adjust(searchClause.getType(), property, (FieldPanel<SearchClause.Comparator>)comparator);
            }
        }});
        final AjaxDropDownChoicePanel type = new AjaxDropDownChoicePanel("type", "type", (IModel)new PropertyModel((Object)searchClause, "type"));
        type.setChoices(this.types).setChoiceRenderer(this.customizer.typeRenderer()).hideLabel().setRequired(this.required).setOutputMarkupId(true);
        type.setNullValid(false);
        type.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                SearchClause searchClause = new SearchClause();
                if (StringUtils.isNotEmpty((CharSequence)type.getDefaultModelObjectAsString())) {
                    searchClause.setType(SearchClause.Type.valueOf(type.getDefaultModelObjectAsString()));
                }
                SearchClausePanel.this.clause.setObject((Object)searchClause);
                SearchClausePanel.this.adjust(searchClause.getType(), property, (FieldPanel<SearchClause.Comparator>)comparator);
                property.setModelObject((Serializable)((Object)""));
                target.add(new Component[]{property});
                target.add(new Component[]{comparator});
                target.add(new Component[]{SearchClausePanel.this.value});
            }
        }});
        this.field.add(new Component[]{type});
        comparator.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (type.getModelObject() == SearchClause.Type.ATTRIBUTE || type.getModelObject() == SearchClause.Type.RELATIONSHIP) {
                    if (comparator.getModelObject() == SearchClause.Comparator.IS_NULL || comparator.getModelObject() == SearchClause.Comparator.IS_NOT_NULL) {
                        SearchClausePanel.this.value.setModelObject(null);
                        SearchClausePanel.this.value.setEnabled(false);
                    } else {
                        SearchClausePanel.this.value.setEnabled(true);
                    }
                    target.add(new Component[]{SearchClausePanel.this.value});
                }
                if (type.getModelObject() == SearchClause.Type.RELATIONSHIP) {
                    property.setEnabled(true);
                    SearchClause searchClause = new SearchClause();
                    searchClause.setType(SearchClause.Type.valueOf(type.getDefaultModelObjectAsString()));
                    searchClause.setComparator((SearchClause.Comparator)((Object)comparator.getModelObject()));
                    SearchClausePanel.this.clause.setObject((Object)searchClause);
                    target.add(new Component[]{property});
                }
            }
        }});
        return this;
    }

    protected void adjust(SearchClause.Type type, AjaxTextFieldPanel property, FieldPanel<SearchClause.Comparator> comparator) {
        if (type == null) {
            return;
        }
        property.setEnabled(true);
        comparator.setEnabled(true);
        this.value.setEnabled(true);
        switch (type) {
            case ATTRIBUTE: {
                if (!comparator.isEnabled()) {
                    comparator.setEnabled(true);
                    comparator.setRequired(true);
                }
                if (comparator.getModelObject() == SearchClause.Comparator.IS_NULL || comparator.getModelObject() == SearchClause.Comparator.IS_NOT_NULL) {
                    this.value.setEnabled(false);
                    this.value.setModelObject(null);
                }
                this.properties.detach();
                property.setChoices(((List)this.properties.getObject()).stream().map(Pair::getValue).collect(Collectors.toList()));
                break;
            }
            case ROLE_MEMBERSHIP: {
                this.value.setEnabled(false);
                this.value.setModelObject(null);
                this.properties.detach();
                property.setChoices(((List)this.properties.getObject()).stream().map(Pair::getKey).collect(Collectors.toList()));
                break;
            }
            case PRIVILEGE: {
                this.value.setEnabled(false);
                this.value.setModelObject(null);
                this.properties.detach();
                property.setChoices(((List)this.properties.getObject()).stream().map(Pair::getKey).collect(Collectors.toList()));
                break;
            }
            case GROUP_MEMBERSHIP: {
                this.value.setEnabled(false);
                this.value.setModelObject(null);
                this.properties.detach();
                property.setChoices(((List)this.properties.getObject()).stream().map(Pair::getKey).collect(Collectors.toList()));
                break;
            }
            case GROUP_MEMBER: {
                this.value.setEnabled(true);
                property.setEnabled(false);
                property.setModelObject(null);
                break;
            }
            case AUX_CLASS: 
            case RESOURCE: {
                this.value.setEnabled(false);
                this.value.setModelObject(null);
                this.properties.detach();
                property.setChoices(((List)this.properties.getObject()).stream().map(Pair::getKey).collect(Collectors.toList()));
                break;
            }
            case RELATIONSHIP: {
                this.value.setEnabled(true);
                this.value.setModelObject(null);
                property.setEnabled(true);
                this.properties.detach();
                property.setChoices(((List)this.properties.getObject()).stream().map(Pair::getKey).collect(Collectors.toList()));
                break;
            }
            case CUSTOM: {
                this.customizer.adjust(type, property, comparator, this.value, this.properties);
                break;
            }
        }
    }

    private FieldPanel<?> buildValue(final SearchClause searchClause, AjaxTextFieldPanel property) {
        AjaxTextFieldPanel result;
        PlainSchemaTO plainSchema = Optional.ofNullable((PlainSchemaTO)((Map)this.anames.getObject()).get(property.getModelObject())).orElseGet(() -> {
            PlainSchemaTO defaultPlainTO = new PlainSchemaTO();
            defaultPlainTO.setType(AttrSchemaType.String);
            return Optional.ofNullable((String)((Object)property.getModelObject())).map(k -> ((Map)this.dnames.getObject()).getOrDefault(k, defaultPlainTO)).orElse(defaultPlainTO);
        });
        switch (plainSchema.getType()) {
            case Boolean: {
                result = new AjaxTextFieldPanel("value", "value", (IModel)new PropertyModel((Object)searchClause, "value"), true);
                result.setChoices(Arrays.asList("true", "false"));
                break;
            }
            case Date: {
                final FastDateFormat formatter = StringUtils.isBlank((CharSequence)plainSchema.getConversionPattern()) ? DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT : FastDateFormat.getInstance((String)plainSchema.getConversionPattern());
                PropertyModel<Date> dateModel = new PropertyModel<Date>((Object)searchClause, "value"){
                    private static final long serialVersionUID = -3743432456095828573L;

                    public Date getObject() {
                        try {
                            return StringUtils.isBlank((CharSequence)searchClause.getValue()) ? null : formatter.parse(searchClause.getValue());
                        }
                        catch (ParseException e) {
                            LOG.error("Unparsable date: {}", (Object)searchClause.getValue(), (Object)e);
                            return null;
                        }
                    }

                    public void setObject(Date object) {
                        Optional.ofNullable(object).ifPresent(date -> searchClause.setValue(formatter.format(date)));
                    }
                };
                if (plainSchema.getConversionPattern() == null || StringUtils.containsIgnoreCase((CharSequence)plainSchema.getConversionPattern(), (CharSequence)"H")) {
                    result = new AjaxDateTimeFieldPanel("value", "value", (IModel)dateModel, formatter);
                    break;
                }
                result = new AjaxDateFieldPanel("value", "value", (IModel)dateModel, formatter);
                break;
            }
            case Enum: {
                result = new AjaxDropDownChoicePanel("value", "value", (IModel)new PropertyModel((Object)searchClause, "value"), true);
                ((AjaxDropDownChoicePanel)result).setChoices(SchemaUtils.getEnumeratedValues((PlainSchemaTO)plainSchema));
                if (!StringUtils.isNotBlank((CharSequence)plainSchema.getEnumerationKeys())) break;
                final Map valueMap = SchemaUtils.getEnumeratedKeyValues((PlainSchemaTO)plainSchema);
                ((AjaxDropDownChoicePanel)result).setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<String>(){
                    private static final long serialVersionUID = -3724971416312135885L;

                    public String getDisplayValue(String value) {
                        return valueMap.get(value) == null ? value : (String)valueMap.get(value);
                    }

                    public String getIdValue(String value, int i) {
                        return value;
                    }

                    public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                        return id;
                    }
                });
                break;
            }
            case Long: {
                result = new AjaxNumberFieldPanel.Builder().enableOnChange().build("value", "Value", Long.class, (IModel)new PropertyModel((Object)searchClause, "value"));
                result.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"field value search-spinner"))});
                break;
            }
            case Double: {
                result = new AjaxNumberFieldPanel.Builder().enableOnChange().step((Number)0.1).build("value", "value", Double.class, (IModel)new PropertyModel((Object)searchClause, "value"));
                result.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"field value search-spinner"))});
                break;
            }
            default: {
                result = new AjaxTextFieldPanel("value", "value", (IModel)new PropertyModel((Object)searchClause, "value"), true);
            }
        }
        result.hideLabel().setOutputMarkupId(true);
        result.getField().add(new Behavior[]{PREVENT_DEFAULT_RETURN});
        result.getField().add(new Behavior[]{new IndicatorAjaxEventBehavior("keydown", (FieldPanel)result){
            private static final long serialVersionUID = -7133385027739964990L;
            final /* synthetic */ FieldPanel val$result;
            {
                this.val$result = fieldPanel;
                super(event);
            }

            protected void onEvent(AjaxRequestTarget target) {
                target.focusComponent(null);
                this.val$result.getField().inputChanged();
                this.val$result.getField().validate();
                if (this.val$result.getField().isValid()) {
                    this.val$result.getField().valid();
                    this.val$result.getField().updateModel();
                }
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AJAX_SUBMIT_ON_RETURN.accept(attributes);
            }
        }});
        return result;
    }

    public FieldPanel<SearchClause> clone() {
        SearchClausePanel panel = new SearchClausePanel(this.getId(), this.name, null, this.required, this.types, this.customizer, this.anames, this.dnames, this.groupInfo, this.roleNames, this.privilegeNames, this.auxClassNames, this.resourceNames);
        panel.setReadOnly(this.isReadOnly());
        panel.setRequired(this.isRequired());
        if (this.searchButton.isEnabled()) {
            panel.enableSearch(this.resultContainer);
        }
        return panel;
    }

    public static class SearchEvent
    implements Serializable {
        private static final long serialVersionUID = 2693338614198749301L;
        private final AjaxRequestTarget target;

        public SearchEvent(AjaxRequestTarget target) {
            this.target = target;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }

    protected class ComparatorRenderer
    implements IChoiceRenderer<SearchClause.Comparator> {
        private static final long serialVersionUID = -9086043750227867686L;

        protected ComparatorRenderer() {
        }

        public Object getDisplayValue(SearchClause.Comparator object) {
            String display;
            if (SearchClausePanel.this.clause == null || SearchClausePanel.this.clause.getObject() == null || ((SearchClause)SearchClausePanel.this.clause.getObject()).getType() == null) {
                return object.toString();
            }
            block0 : switch (((SearchClause)SearchClausePanel.this.clause.getObject()).getType()) {
                case ATTRIBUTE: {
                    switch (object) {
                        case IS_NULL: {
                            display = "NULL";
                            break block0;
                        }
                        case IS_NOT_NULL: {
                            display = "NOT NULL";
                            break block0;
                        }
                        case EQUALS: {
                            display = "==";
                            break block0;
                        }
                        case NOT_EQUALS: {
                            display = "!=";
                            break block0;
                        }
                        case LESS_THAN: {
                            display = "<";
                            break block0;
                        }
                        case LESS_OR_EQUALS: {
                            display = "<=";
                            break block0;
                        }
                        case GREATER_THAN: {
                            display = ">";
                            break block0;
                        }
                        case GREATER_OR_EQUALS: {
                            display = ">=";
                            break block0;
                        }
                    }
                    display = "";
                    break;
                }
                case GROUP_MEMBERSHIP: {
                    switch (object) {
                        case EQUALS: {
                            display = "IN";
                            break block0;
                        }
                        case NOT_EQUALS: {
                            display = "NOT IN";
                            break block0;
                        }
                    }
                    display = "";
                    break;
                }
                case GROUP_MEMBER: {
                    switch (object) {
                        case EQUALS: {
                            display = "WITH";
                            break block0;
                        }
                        case NOT_EQUALS: {
                            display = "WITHOUT";
                            break block0;
                        }
                    }
                    display = "";
                    break;
                }
                case AUX_CLASS: 
                case ROLE_MEMBERSHIP: 
                case PRIVILEGE: 
                case RESOURCE: {
                    switch (object) {
                        case EQUALS: {
                            display = "HAS";
                            break block0;
                        }
                        case NOT_EQUALS: {
                            display = "HAS NOT";
                            break block0;
                        }
                    }
                    display = "";
                    break;
                }
                case RELATIONSHIP: {
                    switch (object) {
                        case IS_NOT_NULL: {
                            display = "EXIST";
                            break block0;
                        }
                        case IS_NULL: {
                            display = "NOT EXIST";
                            break block0;
                        }
                        case EQUALS: {
                            display = "WITH";
                            break block0;
                        }
                        case NOT_EQUALS: {
                            display = "WITHOUT";
                            break block0;
                        }
                    }
                    display = "";
                    break;
                }
                case CUSTOM: {
                    display = SearchClausePanel.this.customizer.comparatorDisplayValue(object);
                    break;
                }
                default: {
                    display = object.toString();
                }
            }
            return display;
        }

        public String getIdValue(SearchClause.Comparator object, int index) {
            return this.getDisplayValue(object).toString();
        }

        public SearchClause.Comparator getObject(String id, IModel<? extends List<? extends SearchClause.Comparator>> choices) {
            SearchClause.Comparator comparator;
            if (id == null) {
                return SearchClause.Comparator.EQUALS;
            }
            switch (id) {
                case "HAS": 
                case "IN": 
                case "WITH": {
                    comparator = SearchClause.Comparator.EQUALS;
                    break;
                }
                case "HAS NOT": 
                case "NOT IN": 
                case "WITHOUT": {
                    comparator = SearchClause.Comparator.NOT_EQUALS;
                    break;
                }
                case "NULL": 
                case "NOT EXIST": {
                    comparator = SearchClause.Comparator.IS_NULL;
                    break;
                }
                case "NOT NULL": 
                case "EXIST": {
                    comparator = SearchClause.Comparator.IS_NOT_NULL;
                    break;
                }
                case "==": {
                    comparator = SearchClause.Comparator.EQUALS;
                    break;
                }
                case "!=": {
                    comparator = SearchClause.Comparator.NOT_EQUALS;
                    break;
                }
                case "<": {
                    comparator = SearchClause.Comparator.LESS_THAN;
                    break;
                }
                case "<=": {
                    comparator = SearchClause.Comparator.LESS_OR_EQUALS;
                    break;
                }
                case ">": {
                    comparator = SearchClause.Comparator.GREATER_THAN;
                    break;
                }
                case ">=": {
                    comparator = SearchClause.Comparator.GREATER_OR_EQUALS;
                    break;
                }
                default: {
                    comparator = SearchClausePanel.this.customizer.comparatorGetObject(id).orElse(SearchClause.Comparator.EQUALS);
                }
            }
            return comparator;
        }
    }

    public static interface Customizer
    extends Serializable {
        default public IChoiceRenderer<SearchClause.Type> typeRenderer() {
            return new ChoiceRenderer();
        }

        default public List<SearchClause.Comparator> comparators() {
            return List.of();
        }

        default public String comparatorDisplayValue(SearchClause.Comparator object) {
            return object.toString();
        }

        default public Optional<SearchClause.Comparator> comparatorGetObject(String id) {
            return Optional.empty();
        }

        default public List<String> properties() {
            return List.of();
        }

        default public void adjust(SearchClause.Type type, AjaxTextFieldPanel property, FieldPanel<SearchClause.Comparator> comparator, FieldPanel<?> value, LoadableDetachableModel<List<Pair<String, String>>> properties) {
            value.setEnabled(true);
            value.setModelObject(null);
            property.setEnabled(true);
            properties.detach();
            property.setChoices(((List)properties.getObject()).stream().map(Pair::getKey).collect(Collectors.toList()));
        }
    }
}

