/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.io.NonSyncByteArrayInputStream;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputCallback;

public class MemoryFetchedInput
extends FetchedInput {
    private byte[] byteArray;

    public MemoryFetchedInput(long actualSize, InputAttemptIdentifier inputAttemptIdentifier, FetchedInputCallback callbackHandler) {
        super(inputAttemptIdentifier, callbackHandler);
        this.byteArray = new byte[(int)actualSize];
    }

    @Override
    public FetchedInput.Type getType() {
        return FetchedInput.Type.MEMORY;
    }

    @Override
    public long getSize() {
        if (this.byteArray == null) {
            return 0L;
        }
        return this.byteArray.length;
    }

    @Override
    public OutputStream getOutputStream() {
        return new InMemoryBoundedByteArrayOutputStream(this.byteArray);
    }

    @Override
    public InputStream getInputStream() {
        return new NonSyncByteArrayInputStream(this.byteArray);
    }

    public byte[] getBytes() {
        return this.byteArray;
    }

    @Override
    public void commit() {
        if (this.isState(FetchedInput.State.PENDING)) {
            this.setState(FetchedInput.State.COMMITTED);
            this.notifyFetchComplete();
        }
    }

    @Override
    public void abort() {
        if (this.isState(FetchedInput.State.PENDING)) {
            this.setState(FetchedInput.State.ABORTED);
            this.notifyFetchFailure();
        }
    }

    @Override
    public void free() {
        Preconditions.checkState((this.isState(FetchedInput.State.COMMITTED) || this.isState(FetchedInput.State.ABORTED) ? 1 : 0) != 0, (Object)"FetchedInput can only be freed after it is committed or aborted");
        if (this.isState(FetchedInput.State.COMMITTED)) {
            this.setState(FetchedInput.State.FREED);
            this.notifyFreedResource();
            this.byteArray = null;
        }
    }

    public String toString() {
        return "MemoryFetchedInput [inputAttemptIdentifier=" + this.getInputAttemptIdentifier() + ", size=" + this.getSize() + ", type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", state=" + (Object)((Object)this.getState()) + "]";
    }

    private static class InMemoryBoundedByteArrayOutputStream
    extends BoundedByteArrayOutputStream {
        InMemoryBoundedByteArrayOutputStream(byte[] array) {
            super(array, 0, array.length);
        }
    }
}

