/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.proxy.Collaborator;
import org.apache.aries.proxy.InvocationListener;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleInterceptorCollaborator
implements InvocationListener,
Serializable {
    private static final long serialVersionUID = -58189302118314469L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Collaborator.class);
    private transient Interceptor interceptor;
    private transient ComponentMetadata cm;
    private static final Object NON_INVOKED = new Object();

    public SingleInterceptorCollaborator(ComponentMetadata cm, Interceptor interceptor) {
        this.cm = cm;
        this.interceptor = interceptor;
    }

    public Object preInvoke(Object o, Method m, Object[] parameters) throws Throwable {
        Object callToken = NON_INVOKED;
        try {
            callToken = this.interceptor.preCall(this.cm, m, parameters);
        }
        catch (Throwable t) {
            this.postInvokeExceptionalReturn(callToken, o, m, t);
            throw t;
        }
        return callToken;
    }

    public void postInvoke(Object token, Object o, Method method, Object returnType) throws Throwable {
        if (token != NON_INVOKED) {
            try {
                this.interceptor.postCallWithReturn(this.cm, method, returnType, token);
            }
            catch (Throwable t) {
                LOGGER.debug("postCallInterceptorWithReturn", t);
                throw t;
            }
        }
    }

    public void postInvokeExceptionalReturn(Object token, Object o, Method method, Throwable exception) throws Throwable {
        try {
            this.interceptor.postCallWithException(this.cm, method, exception, token);
        }
        catch (Throwable t) {
            LOGGER.debug("postCallInterceptorWithException", t);
            throw t;
        }
    }
}

