/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.net.UnknownHostException;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.StaticService;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.ha.CamelClusterService;
import org.apache.camel.management.JmxNotificationEventNotifier;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.ManagementNamingStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.InetAddressUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class DefaultManagementNamingStrategy
implements ManagementNamingStrategy,
CamelContextAware {
    public static final String VALUE_UNKNOWN = "unknown";
    public static final String KEY_NAME = "name";
    public static final String KEY_TYPE = "type";
    public static final String KEY_CONTEXT = "context";
    public static final String TYPE_CONTEXT = "context";
    public static final String TYPE_ROUTE_CONTROLLER = "routecontroller";
    public static final String TYPE_HEALTH = "health";
    public static final String TYPE_ENDPOINT = "endpoints";
    public static final String TYPE_DATAFORMAT = "dataformats";
    public static final String TYPE_PROCESSOR = "processors";
    public static final String TYPE_CONSUMER = "consumers";
    public static final String TYPE_PRODUCER = "producers";
    public static final String TYPE_ROUTE = "routes";
    public static final String TYPE_COMPONENT = "components";
    public static final String TYPE_TRACER = "tracer";
    public static final String TYPE_EVENT_NOTIFIER = "eventnotifiers";
    public static final String TYPE_ERRORHANDLER = "errorhandlers";
    public static final String TYPE_THREAD_POOL = "threadpools";
    public static final String TYPE_SERVICE = "services";
    public static final String TYPE_HA = "ha";
    protected String domainName;
    protected String hostName = "localhost";
    protected CamelContext camelContext;

    public DefaultManagementNamingStrategy() {
        this("org.apache.camel");
    }

    public DefaultManagementNamingStrategy(String domainName) {
        if (domainName != null) {
            this.domainName = domainName;
        }
        try {
            this.hostName = InetAddressUtil.getLocalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public ObjectName getObjectNameForCamelContext(String managementName, String name) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(managementName)).append(",");
        buffer.append("type=context,");
        buffer.append("name=").append(ObjectName.quote(name));
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForCamelContext(CamelContext context) throws MalformedObjectNameException {
        String managementName = context.getManagementName();
        if (managementName == null) {
            managementName = context.getManagementNameStrategy().getName();
        }
        String name = context.getName();
        return this.getObjectNameForCamelContext(managementName, name);
    }

    @Override
    public ObjectName getObjectNameForCamelHealth(CamelContext context) throws MalformedObjectNameException {
        String managementName = context.getManagementName();
        if (managementName == null) {
            managementName = context.getManagementNameStrategy().getName();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(managementName)).append(",");
        buffer.append("type=health,");
        buffer.append("name=").append(ObjectName.quote(context.getName()));
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForRouteController(CamelContext context) throws MalformedObjectNameException {
        String managementName = context.getManagementName();
        if (managementName == null) {
            managementName = context.getManagementNameStrategy().getName();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(managementName)).append(",");
        buffer.append("type=routecontroller,");
        buffer.append("name=").append(ObjectName.quote(context.getName()));
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForEndpoint(Endpoint endpoint) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(endpoint.getCamelContext())).append(",");
        buffer.append("type=endpoints,");
        buffer.append("name=").append(ObjectName.quote(this.getEndpointId(endpoint)));
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForDataFormat(CamelContext context, DataFormat dataFormat) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=dataformats,");
        buffer.append("name=").append(dataFormat.getClass().getSimpleName());
        if (!(dataFormat instanceof StaticService)) {
            buffer.append("(").append(ObjectHelper.getIdentityHashCode(dataFormat)).append(")");
        }
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForComponent(Component component, String name) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(component.getCamelContext())).append(",");
        buffer.append("type=components,");
        buffer.append("name=").append(ObjectName.quote(name));
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForProcessor(CamelContext context, Processor processor, NamedNode definition) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=").append(TYPE_PROCESSOR).append(",");
        buffer.append("name=").append(ObjectName.quote(definition.getId()));
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForErrorHandler(RouteContext routeContext, Processor errorHandler, ErrorHandlerFactory builder) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(routeContext.getCamelContext())).append(",");
        buffer.append("type=").append("errorhandlers,");
        String ref = null;
        if (builder instanceof ErrorHandlerBuilderRef) {
            ErrorHandlerBuilderRef builderRef = (ErrorHandlerBuilderRef)builder;
            ref = builderRef.getRef();
            ErrorHandlerFactory refBuilder = ErrorHandlerBuilderRef.lookupErrorHandlerBuilder(routeContext, builderRef.getRef(), false);
            if (refBuilder != null) {
                builder = refBuilder;
            }
            if (builder instanceof ErrorHandlerBuilderRef && !(builderRef = (ErrorHandlerBuilderRef)builder).getRef().equals("CamelDefaultErrorHandlerBuilder") && (refBuilder = ErrorHandlerBuilderRef.lookupErrorHandlerBuilder(routeContext, builderRef.getRef(), false)) != null) {
                ref = builderRef.getRef();
                builder = refBuilder;
            }
        }
        if (ref != null) {
            String name = builder.getClass().getSimpleName() + "(ref:" + ref + ")";
            buffer.append("name=").append(ObjectName.quote(name));
        } else {
            buffer.append("name=").append(builder.getClass().getSimpleName()).append("(").append(ObjectHelper.getIdentityHashCode(builder)).append(")");
        }
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForConsumer(CamelContext context, Consumer consumer) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=").append(TYPE_CONSUMER).append(",");
        String name = consumer.getClass().getSimpleName();
        if (ObjectHelper.isEmpty(name)) {
            name = "Consumer";
        }
        buffer.append("name=").append(name).append("(").append(ObjectHelper.getIdentityHashCode(consumer)).append(")");
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForProducer(CamelContext context, Producer producer) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=").append(TYPE_PRODUCER).append(",");
        String name = producer.getClass().getSimpleName();
        if (ObjectHelper.isEmpty(name)) {
            name = "Producer";
        }
        buffer.append("name=").append(name).append("(").append(ObjectHelper.getIdentityHashCode(producer)).append(")");
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForTracer(CamelContext context, InterceptStrategy tracer) throws MalformedObjectNameException {
        String name = tracer.getClass().getSimpleName();
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=tracer,");
        buffer.append("name=").append(name);
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForEventNotifier(CamelContext context, EventNotifier eventNotifier) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=eventnotifiers,");
        if (eventNotifier instanceof JmxNotificationEventNotifier) {
            buffer.append("name=").append("JmxEventNotifier");
        } else {
            buffer.append("name=").append("EventNotifier").append("(").append(ObjectHelper.getIdentityHashCode(eventNotifier)).append(")");
        }
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForRoute(Route route) throws MalformedObjectNameException {
        Endpoint ep = route.getEndpoint();
        String id = route.getId();
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(ep.getCamelContext())).append(",");
        buffer.append("type=routes,");
        buffer.append("name=").append(ObjectName.quote(id));
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForService(CamelContext context, Service service) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=services,");
        buffer.append("name=").append(service.getClass().getSimpleName());
        if (!(service instanceof StaticService)) {
            buffer.append("(").append(ObjectHelper.getIdentityHashCode(service)).append(")");
        }
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForClusterService(CamelContext context, CamelClusterService service) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=ha,");
        buffer.append("name=").append(service.getClass().getSimpleName());
        if (!(service instanceof StaticService)) {
            buffer.append("(").append(ObjectHelper.getIdentityHashCode(service)).append(")");
        }
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForThreadPool(CamelContext context, ThreadPoolExecutor threadPool, String id, String sourceId) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=threadpools,");
        String name = id;
        if (sourceId != null) {
            name = name + "(" + sourceId + ")";
        }
        buffer.append("name=").append(ObjectName.quote(name));
        return this.createObjectName(buffer);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    protected String getContextId(CamelContext context) {
        if (context == null) {
            return this.getContextId(VALUE_UNKNOWN);
        }
        String name = context.getManagementName() != null ? context.getManagementName() : context.getName();
        return this.getContextId(name);
    }

    protected String getContextId(String name) {
        Boolean includeHostName = this.camelContext != null && this.camelContext.getManagementStrategy().getManagementAgent().getIncludeHostName() != false;
        if (includeHostName != null && includeHostName.booleanValue()) {
            return this.hostName + "/" + (name != null ? name : VALUE_UNKNOWN);
        }
        return name != null ? name : VALUE_UNKNOWN;
    }

    protected String getEndpointId(Endpoint ep) {
        String answer = this.doGetEndpointId(ep);
        Boolean sanitize = this.camelContext != null && this.camelContext.getManagementStrategy().getManagementAgent().getMask() != false;
        if (sanitize != null && sanitize.booleanValue()) {
            answer = URISupport.sanitizeUri(answer);
        }
        return answer;
    }

    private String doGetEndpointId(Endpoint ep) {
        if (ep.isSingleton()) {
            return ep.getEndpointKey();
        }
        String uri = ep.getEndpointKey();
        int pos = uri.indexOf(63);
        String id = pos == -1 ? uri : uri.substring(0, pos);
        id = id + "?id=" + ObjectHelper.getIdentityHashCode(ep);
        return id;
    }

    protected ObjectName createObjectName(StringBuilder buffer) throws MalformedObjectNameException {
        String text = buffer.toString();
        try {
            return new ObjectName(text);
        }
        catch (MalformedObjectNameException e) {
            throw new MalformedObjectNameException("Could not create ObjectName from: " + text + ". Reason: " + e);
        }
    }
}

