/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.usage.NodesUsageRequest;
import org.elasticsearch.action.admin.cluster.node.usage.NodesUsageResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestNodesUsageAction
extends BaseRestHandler {
    @Inject
    public RestNodesUsageAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/usage", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/usage", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/usage/{metric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/usage/{metric}", this);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        Set<String> metrics = Strings.tokenizeByCommaToSet(request.param("metric", "_all"));
        NodesUsageRequest nodesUsageRequest = new NodesUsageRequest(nodesIds);
        nodesUsageRequest.timeout(request.param("timeout"));
        if (metrics.size() == 1 && metrics.contains("_all")) {
            nodesUsageRequest.all();
        } else {
            if (metrics.contains("_all")) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains _all and individual metrics [%s]", request.path(), request.param("metric")));
            }
            nodesUsageRequest.clear();
            nodesUsageRequest.restActions(metrics.contains("rest_actions"));
        }
        return channel -> client.admin().cluster().nodesUsage(nodesUsageRequest, (ActionListener<NodesUsageResponse>)new RestBuilderListener<NodesUsageResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesUsageResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildNodesHeader(builder, this.channel.request(), response);
                builder.field("cluster_name", response.getClusterName().value());
                response.toXContent(builder, this.channel.request());
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    public String getName() {
        return "nodes_usage_action";
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

