/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import javax.servlet.Filter;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.DictionaryUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.whiteboard.FilterMapping;
import org.ops4j.pax.web.service.whiteboard.WhiteboardFilter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;

public class FilterWebElement<T extends Filter>
extends WebElement<T>
implements WhiteboardFilter {
    private FilterMapping filterMapping;

    public FilterWebElement(ServiceReference<T> ref, FilterMapping filterMapping) {
        super(ref);
        NullArgumentException.validateNotNull(filterMapping, "Filter mapping");
        this.filterMapping = filterMapping;
        if (filterMapping.getUrlPatterns() == null && filterMapping.getServletNames() == null) {
            this.valid = false;
        }
    }

    @Override
    public void register(WebContainer webContainer, HttpContext httpContext) throws Exception {
        webContainer.registerFilter(this.filterMapping.getFilter(), this.filterMapping.getUrlPatterns(), this.filterMapping.getServletNames(), DictionaryUtils.adapt(this.filterMapping.getInitParams()), this.filterMapping.getAsyncSupported(), httpContext);
    }

    @Override
    public void unregister(WebContainer webContainer, HttpContext httpContext) {
        Filter filter = this.filterMapping.getFilter();
        webContainer.unregisterFilter(filter);
    }

    @Override
    public String getHttpContextId() {
        return this.filterMapping.getHttpContextId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{mapping=" + this.filterMapping + "}";
    }

    public FilterMapping getFilterMapping() {
        return this.filterMapping;
    }
}

