/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.locale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;

public final class LocaleUtils {
    private static final Pattern UNDERSCORE = Pattern.compile("_");

    private LocaleUtils() {
    }

    public static Locale parseLocale(String input) {
        if (input == null) {
            throw new NullPointerException("input cannot be null");
        }
        if (input.isEmpty()) {
            return Locale.ROOT;
        }
        String[] elements = UNDERSCORE.split(input, -1);
        int len = elements.length;
        if (len > 3) {
            throw new IllegalArgumentException("malformed input " + input);
        }
        if (elements[0].isEmpty()) {
            return Locale.ROOT;
        }
        switch (len) {
            case 1: {
                return new Locale(elements[0]);
            }
            case 2: {
                return new Locale(elements[0], elements[1]);
            }
            case 3: {
                return new Locale(elements[0], elements[1], elements[2]);
            }
        }
        throw new IllegalStateException("How did I get there??");
    }

    public static Collection<Locale> getApplicable(Locale target) {
        Locale locale;
        String language = target.getLanguage();
        String country = target.getCountry();
        String variant = target.getVariant();
        ArrayList<Locale> ret = new ArrayList<Locale>();
        ret.add(target);
        if (!variant.isEmpty() && !(locale = new Locale(language, country)).equals(Locale.ROOT)) {
            ret.add(locale);
        }
        if (!country.isEmpty() && !(locale = new Locale(language)).equals(Locale.ROOT)) {
            ret.add(locale);
        }
        if (!language.isEmpty()) {
            ret.add(Locale.ROOT);
        }
        return ret;
    }
}

