/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.ComponentNameAlreadyInUseException;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.reflect.PassThroughMetadataImpl;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Target;

public class ComponentDefinitionRegistryImpl
implements ComponentDefinitionRegistry {
    private final Map<String, ComponentMetadata> components = Collections.synchronizedMap(new LinkedHashMap());
    private final List<Target> typeConverters = new CopyOnWriteArrayList<Target>();
    private final Map<ComponentMetadata, List<Interceptor>> interceptors = Collections.synchronizedMap(new HashMap());

    public void reset() {
        this.components.clear();
        this.typeConverters.clear();
        this.interceptors.clear();
    }

    @Override
    public boolean containsComponentDefinition(String name) {
        return this.components.containsKey(name);
    }

    @Override
    public ComponentMetadata getComponentDefinition(String name) {
        return this.components.get(name);
    }

    @Override
    public Set<String> getComponentDefinitionNames() {
        return Collections.unmodifiableSet(this.components.keySet());
    }

    @Override
    public void registerComponentDefinition(ComponentMetadata component) {
        String id = component.getId();
        if (id == null) {
            throw new IllegalArgumentException("Component must have a valid id");
        }
        if (!id.startsWith("blueprint") || !(component instanceof PassThroughMetadataImpl)) {
            // empty if block
        }
        if (this.components.containsKey(id)) {
            throw new ComponentNameAlreadyInUseException(id);
        }
        this.components.put(id, component);
    }

    @Override
    public void removeComponentDefinition(String name) {
        ComponentMetadata removed = this.components.remove(name);
        if (removed != null) {
            this.interceptors.remove(removed);
        }
    }

    @Override
    public void registerTypeConverter(Target component) {
        this.typeConverters.add(component);
        if (component instanceof ComponentMetadata) {
            this.registerComponentDefinition((ComponentMetadata)component);
        }
    }

    @Override
    public List<Target> getTypeConverters() {
        return this.typeConverters;
    }

    @Override
    public void registerInterceptorWithComponent(ComponentMetadata component, Interceptor interceptor) {
        if (interceptor != null) {
            List<Interceptor> componentInterceptorList = this.interceptors.get(component);
            if (componentInterceptorList == null) {
                componentInterceptorList = new ArrayList<Interceptor>();
                this.interceptors.put(component, componentInterceptorList);
            }
            if (!componentInterceptorList.contains(interceptor)) {
                componentInterceptorList.add(interceptor);
                Collections.sort(componentInterceptorList, new Comparator<Interceptor>(){

                    @Override
                    public int compare(Interceptor object1, Interceptor object2) {
                        return object2.getRank() - object1.getRank();
                    }
                });
            }
        }
    }

    @Override
    public List<Interceptor> getInterceptors(ComponentMetadata component) {
        List<Interceptor> result = this.interceptors.get(component);
        return result == null ? Collections.emptyList() : result;
    }
}

