/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.coordinator.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import org.apache.felix.coordinator.impl.CoordinationHolder;
import org.apache.felix.coordinator.impl.CoordinationMgr;
import org.apache.felix.coordinator.impl.CoordinatorImpl;
import org.apache.felix.coordinator.impl.LogWrapper;
import org.osgi.framework.Bundle;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.coordinator.Participant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinationImpl
implements Coordination {
    private final WeakReference<CoordinationHolder> holderRef;
    private final CoordinatorImpl owner;
    private final long id;
    private final String name;
    private long deadLine;
    private volatile State state;
    private Throwable failReason;
    private final ArrayList<Participant> participants;
    private final Map<Class<?>, Object> variables;
    private TimerTask timeoutTask;
    private Thread associatedThread;
    private final Object waitLock = new Object();

    public static CoordinationMgr.CreationResult create(CoordinatorImpl owner, long id, String name, long timeOutInMs) {
        CoordinationMgr.CreationResult result = new CoordinationMgr.CreationResult();
        result.holder = new CoordinationHolder();
        result.coordination = new CoordinationImpl(owner, id, name, timeOutInMs, result.holder);
        return result;
    }

    private CoordinationImpl(CoordinatorImpl owner, long id, String name, long timeOutInMs, CoordinationHolder holder) {
        this.owner = owner;
        this.id = id;
        this.name = name;
        this.state = State.ACTIVE;
        this.participants = new ArrayList();
        this.variables = new HashMap();
        this.deadLine = timeOutInMs > 0L ? System.currentTimeMillis() + timeOutInMs : 0L;
        holder.setCoordination(this);
        this.holderRef = new WeakReference<CoordinationHolder>(holder);
        this.scheduleTimeout(this.deadLine);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fail(Throwable reason) {
        this.owner.checkPermission(this.name, "participate");
        if (reason == null) {
            throw new IllegalArgumentException("Reason must not be null");
        }
        if (this.startTermination()) {
            this.failReason = reason;
            ArrayList<Participant> releaseList = new ArrayList<Participant>();
            ArrayList<Participant> arrayList = this.participants;
            synchronized (arrayList) {
                releaseList.addAll(this.participants);
                this.participants.clear();
            }
            for (int i = releaseList.size() - 1; i >= 0; --i) {
                Participant part = (Participant)releaseList.get(i);
                try {
                    part.failed(this);
                }
                catch (Exception e) {
                    LogWrapper.getLogger().log(1, "Participant threw exception during call to fail()", e);
                }
                this.owner.releaseParticipant(part);
            }
            this.owner.unregister(this, false);
            this.state = State.FAILED;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notifyAll();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        this.owner.checkPermission(this.name, "initiate");
        if (!this.isTerminated() && this.associatedThread != null && Thread.currentThread() != this.associatedThread) {
            throw new CoordinationException("Coordination is associated with different thread", this, 7);
        }
        if (this.startTermination()) {
            CoordinationException nestedFailed = this.owner.endNestedCoordinations(this);
            if (nestedFailed != null) {
                this.failReason = nestedFailed;
            }
            boolean partialFailure = false;
            this.owner.unregister(this, true);
            ArrayList<Participant> releaseList = new ArrayList<Participant>();
            ArrayList<Participant> arrayList = this.participants;
            synchronized (arrayList) {
                releaseList.addAll(this.participants);
                this.participants.clear();
            }
            for (int i = releaseList.size() - 1; i >= 0; --i) {
                Participant part = (Participant)releaseList.get(i);
                try {
                    if (this.failReason != null) {
                        part.failed(this);
                    } else {
                        part.ended(this);
                    }
                }
                catch (Exception e) {
                    LogWrapper.getLogger().log(1, "Participant threw exception during call to fail()", e);
                    partialFailure = true;
                }
                this.owner.releaseParticipant(part);
            }
            this.state = State.TERMINATED;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notifyAll();
            }
            this.associatedThread = null;
            if (this.failReason != null) {
                throw new CoordinationException("Nested coordination failed", this, 2, this.failReason);
            }
            if (partialFailure) {
                throw new CoordinationException("One or more participants threw while ending the coordination", this, 3);
            }
        } else {
            if (this.state == State.FAILED) {
                this.owner.unregister(this, true);
                this.state = State.TERMINATED;
                throw new CoordinationException("Coordination failed", this, 2, this.failReason);
            }
            throw new CoordinationException("Coordination " + this.id + "/" + this.name + " has already terminated", this, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Participant> getParticipants() {
        this.owner.checkPermission(this.name, "initiate");
        CoordinationImpl coordinationImpl = this;
        synchronized (coordinationImpl) {
            if (this.state == State.ACTIVE) {
                ArrayList<Participant> arrayList = this.participants;
                synchronized (arrayList) {
                    return new ArrayList<Participant>(this.participants);
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Throwable getFailure() {
        this.owner.checkPermission(this.name, "initiate");
        return this.failReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParticipant(Participant p) {
        this.owner.checkPermission(this.name, "participate");
        if (p == null) {
            throw new IllegalArgumentException("Participant must not be null");
        }
        this.owner.lockParticipant(p, this);
        CoordinationImpl coordinationImpl = this;
        synchronized (coordinationImpl) {
            if (this.isTerminated()) {
                this.owner.releaseParticipant(p);
                throw new CoordinationException("Cannot add Participant " + p + " to terminated Coordination", this, this.getFailure() != null ? 2 : 4, this.getFailure());
            }
            ArrayList<Participant> arrayList = this.participants;
            synchronized (arrayList) {
                boolean found = false;
                Iterator<Participant> iter = this.participants.iterator();
                while (!found && iter.hasNext()) {
                    if (iter.next() != p) continue;
                    found = true;
                }
                if (!found) {
                    this.participants.add(p);
                }
            }
        }
    }

    @Override
    public Map<Class<?>, Object> getVariables() {
        this.owner.checkPermission(this.name, "participate");
        return this.variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long extendTimeout(long timeOutInMs) {
        this.owner.checkPermission(this.name, "participate");
        if (timeOutInMs < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        if (this.deadLine > 0L) {
            CoordinationImpl coordinationImpl = this;
            synchronized (coordinationImpl) {
                if (this.isTerminated()) {
                    throw new CoordinationException("Cannot extend timeout on terminated Coordination", this, this.getFailure() != null ? 2 : 4, this.getFailure());
                }
                if (timeOutInMs > 0L) {
                    this.deadLine += timeOutInMs;
                    this.scheduleTimeout(this.deadLine);
                }
            }
        }
        return this.deadLine;
    }

    @Override
    public boolean isTerminated() {
        return this.state != State.ACTIVE;
    }

    @Override
    public Thread getThread() {
        this.owner.checkPermission(this.name, "admin");
        return this.associatedThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join(long timeOutInMs) throws InterruptedException {
        this.owner.checkPermission(this.name, "participate");
        if (timeOutInMs < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        if (!this.isTerminated()) {
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.wait(timeOutInMs);
            }
        }
    }

    @Override
    public Coordination push() {
        this.owner.checkPermission(this.name, "initiate");
        if (this.isTerminated()) {
            throw new CoordinationException("Coordination already ended", this, 4);
        }
        this.owner.push(this);
        return this;
    }

    @Override
    public Bundle getBundle() {
        this.owner.checkPermission(this.name, "admin");
        return this.owner.getBundle();
    }

    @Override
    public Coordination getEnclosingCoordination() {
        this.owner.checkPermission(this.name, "admin");
        Coordination c = this.owner.getEnclosingCoordination(this);
        if (c != null) {
            c = (Coordination)((CoordinationImpl)c).holderRef.get();
        }
        return c;
    }

    private void timeout() {
        this.fail(TIMEOUT);
    }

    private synchronized boolean startTermination() {
        if (this.state == State.ACTIVE) {
            this.state = State.TERMINATING;
            this.scheduleTimeout(-1L);
            return true;
        }
        return false;
    }

    private void scheduleTimeout(long deadLine) {
        if (this.timeoutTask != null) {
            this.owner.schedule(this.timeoutTask, -1L);
            this.timeoutTask = null;
        }
        if (deadLine > System.currentTimeMillis()) {
            this.timeoutTask = new TimerTask(){

                public void run() {
                    CoordinationImpl.this.timeout();
                }
            };
            this.owner.schedule(this.timeoutTask, deadLine);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CoordinationHolder) {
            return obj.equals(this);
        }
        if (!(obj instanceof CoordinationImpl)) {
            return false;
        }
        CoordinationImpl other = (CoordinationImpl)obj;
        return this.id == other.id;
    }

    void setAssociatedThread(Thread t) {
        this.associatedThread = t;
    }

    public Coordination getHolder() {
        return (Coordination)this.holderRef.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        ACTIVE,
        FAILED,
        TERMINATING,
        TERMINATED;

    }
}

