/*
  EDMA IDFWizard GNOMIZED Version 0.5.0
  Copyright (C) 1998,1999,2002,2005 David Martnez Oliveira
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>
#include <gnome.h>

#include <edma.h>

/*Forms */
#include "generalform.h"
#include "propform.h"
#include "metform.h"
#include "inhform.h"
#include "prefform.h"

#include "filemake.h"

extern GeneralWidgets ggw;
extern PropertyWidgets gpw;
extern MethodWidgets gmw;
extern InheritanceWidgets giw;
extern PrefWidgets gfw;

#define NTYPES 16

EPChar   type[NTYPES]={ "EUint32","ESint32",
			"EUint16","ESint16",
			"EUint8","ESint8",
			"EByte","EWord","EDWord",
			"EChar","EBool",
			"EReal32","EReal64",
			"EPChar","EDMAT_BUFFER","OBJID"};

EPChar   typeid[NTYPES]={ "EUINT32","ESINT32",
			"EUINT16","ESINT16",
			"EUINT8","ESINT8",
			"EBYTE","EWORD","EDWORD",
			"ECHAR","EBOOL",
			"EREAL32","EREAL64",
			"EZSTRING","EBUFFER","EOBJECT"};


/***** Helper Function
 * If the file fname exists show a dialog asking user to
 * override the file.
 *
 * Functions return 0 on override or 1 on cancel
*/

int 
TestFile (EPChar fname) 
{
  GtkWidget *ask;
  ESint32   i;
  
  if ((ESint32)(edma_smet3 ("FILESYSTEM", "TestFile", fname)) == 1) 
    {
      ask = gnome_ok_cancel_dialog ("File Exists. Override?",
				    NULL,
				    NULL);
      i = gnome_dialog_run_and_close (GNOME_DIALOG(ask));
      g_print ("Dialog Result: %d\n", i);
      return i;
    }

}

void 
save_idf_file (GtkWidget *widget, GtkWidget *fs)
{
  gchar      *fname;
  EChar      temp[256];
  ESint32    i, n, j;
  FILE       *f;
  GtkWidget  *msg;
  OBJID      id, id1;
  GtkWidget  *ask;

  fname= gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
  if (TestFile (fname)) 
    {
      gtk_widget_destroy (fs);
      return;
    }
  
  g_print ("IDF FIle: %s\n", fname);
  if ((id = edma_new_obj ("CLASS_METADATA")) == -1) 
    {
      g_print ("[ERROR] Can't create CLASS_METADA Object");
      gnome_error_dialog ("Can't Create CLASS_METADA Object. Aborting");
      gtk_widget_destroy (fs);
      return;
  }

  build_metada_obj (id);
  if ((id1 = edma_new_obj("EDMAIDF_BUILDER")) == -1) 
    {
      g_print ("[ERROR] Can't create EDMAIDF_BUILDER Object");
      gnome_error_dialog ("Can't Create EDMAIDF_BUILDER Object. Aborting");
      gtk_widget_destroy (fs);
      edma_free_obj (id);
      return;
    }
  
  edma_met3 (id1, "build", id, fname);
  edma_free_obj (id1);
  edma_free_obj (id);

  gtk_widget_destroy (fs);
}


void 
save_ines_file (GtkWidget *widget, GtkWidget *fs)
{
  gchar      *fname;
  EChar      temp[256];
  ESint32    i, n;
  FILE       *f;
  GtkWidget  *msg;
  OBJID      id, id1;
  
  fname = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
  if (TestFile (fname)) 
    {
      gtk_widget_destroy (fs);
      return;
  }

  g_print ("INES FIle: %s\n", fname);
  if ((id = edma_new_obj ("CLASS_METADATA")) == -1) 
    {
      g_print ("[ERROR] Can't create CLASS_METADATA Object");
      gnome_error_dialog ("Can't Create CLASS_METADATA Object. Aborting");
      gtk_widget_destroy (fs);
      return;
    }
  
  build_metada_obj (id);
  if ((id1 = edma_new_obj ("EDMA_INES_BUILDER")) == -1) 
    {
      g_print ("[ERROR] Can't create EDMA_INES_BUILDER Object");
      gnome_error_dialog ("Can't Create EDMA_INES_BUILDER Object. Aborting");
      gtk_widget_destroy (fs);
      edma_free_obj (id);
      return;
    }

  edma_met3 (id1, "build", id, fname);
  edma_free_obj (id1);
  edma_free_obj (id);

  gtk_widget_destroy (fs);
}

/*
** Builds implementation file according Target Language Field from General Form
**
*/

void 
save_imp_file (GtkWidget *widget, GtkWidget *fs)
{
  gchar      *fname;
  EChar      temp[256], temp1[256], temp2[256], *aux;
  ESint32    i, n, j;
  FILE       *f;
  GtkWidget  *msg;
  OBJID      id, id1, id2;

  fname = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
  if (TestFile (fname)) 
    {
      gtk_widget_destroy (fs);
      return;
    }
  
  g_print ("Implementation FIle: %s\n", fname);
  g_print ("Creating CLASS_METADATA object\n");

  if ((id = edma_new_obj ("CLASS_METADATA")) == -1) 
    {
      g_print ("[ERROR] Can't create CLASS_METADATA Object");
      gnome_error_dialog ("Can't Create CLASS_METADATA Object. Aborting");
      gtk_widget_destroy(fs);
      return;
    }

  g_print ("Populating CLASS_METADA object\n");
  build_metada_obj (id);

  g_print ("Looking for apropiated builder class");
  GeneralGetTargetLanguage (&ggw, temp);
  for (i = 0; i < ggw.n; i++) 
    {
      if (strcmp (ggw.lang_desc[i], temp) == 0)
	break;
      if (i == ggw.n)
	g_print ("Opps!.. There's a problem with Language Definition");
    }
  
  g_print ("Using BUilder Class : %s",ggw.lang_imp_classes[i]);
  
  if ((id1 = edma_new_obj (ggw.lang_imp_classes[i])) == -1) 
    {
      g_print ("[ERROR] Can't create %s Object",ggw.lang_imp_classes[i]);
      sprintf (temp,"Can't create %s Object",ggw.lang_imp_classes[i]);
      gnome_error_dialog (temp);
      gtk_widget_destroy (fs);
      edma_free_obj (id);
      return;
  }
  edma_met3 (id1, "build", id, fname);
  edma_free_obj (id1);
  edma_free_obj (id);

  gtk_widget_destroy (fs);
}

void 
save_c_file (GtkWidget *widget, GtkWidget *fs)
{
  gchar      *fname;
  EChar      temp[256], temp1[256], temp2[256];
  ESint32    i, n, j;
  FILE       *f;
  GtkWidget  *msg;
  OBJID      id, id1;

  fname = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
  if (TestFile (fname)) 
    {
      gtk_widget_destroy (fs);
      return;
    }

  g_print ("C FIle: %s\n", fname);

  if ((id = edma_new_obj ("CLASS_METADATA")) == -1) 
    {
      g_print ("[ERROR] Can't create CLASS_METADATA Object");
      gnome_error_dialog ("Can't Create CLASS_METADATA Object. Aborting");
      gtk_widget_destroy (fs);
      return;    
    }

  build_metada_obj (id);
  
  if ((id1 = edma_new_obj ("EDMA_C_IMP_BUILDER")) == -1) 
    {
      g_print ("[ERROR] Can't create EDMA_C_IMP_BUILDER Object");
      gnome_error_dialog ("Can't Create EDMA_C_IMP_BUILDER Object. Aborting");
      gtk_widget_destroy (fs);
      edma_free_obj (id);
      return;    
    }
  edma_met3 (id1, "build", id, fname);
  edma_free_obj (id1);
  edma_free_obj (id);

  gtk_widget_destroy (fs);
}

void 
save_make_file (GtkWidget *widget, GtkWidget *fs)
{
  gchar      *fname;
  EChar      temp[256], temp1[256], temp2[256], *aux;
  ESint32    i, n, j;
  FILE       *f;
  GtkWidget  *msg;
  OBJID      id, id1, id2;
  
  fname = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
  if (TestFile (fname)) 
    {
      gtk_widget_destroy (fs);
      return;
    }
  
  g_print ("Make FIle: %s\n", fname);

  if ((id = edma_new_obj ("CLASS_METADATA")) == -1) 
    {
      g_print ("[ERROR] Can't create CLASS_METADATA Object");
      gnome_error_dialog ("Can't Create CLASS_METADATA Object. Aborting");
      gtk_widget_destroy (fs);
      return;    
    }
  
  build_metada_obj (id);
  
  GeneralGetTargetLanguage (&ggw, temp);
  for (i = 0; i < ggw.n; i++) 
    {
    if (strcmp (ggw.lang_desc[i], temp) == 0) 
      break;
    if (i == ggw.n)
      g_print ("Opps!.. There's a problem with Language Definition");
    }
  
  g_print ("Using BUilder Class : %s",ggw.lang_make_classes[i]);
  
  if ((id1 = edma_new_obj (ggw.lang_make_classes[i])) == -1) 
    {
      g_print ("[ERROR] Can't create %s Object", ggw.lang_make_classes[i]);
      sprintf (temp, "Can't create %s Object", ggw.lang_make_classes[i]);
      gnome_error_dialog (temp);
      gtk_widget_destroy (fs);
      edma_free_obj (id);
      return;
    }
  
  edma_met3 (id1, "build", id, fname);
  edma_free_obj (id1);
  edma_free_obj (id);
  
  gtk_widget_destroy (fs);
}

void 
save_doc_file (GtkWidget *widget, GtkWidget *fs)
{
  gchar      *fname;
  EChar      temp[256], temp1[256], temp2[256];
  ESint32    i, n, j;
  FILE       *f;
  GtkWidget  *msg;
  OBJID      id, id1;
 
  fname = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
  if (TestFile (fname)) 
    {
      gtk_widget_destroy (fs);
      return;
    }

  g_print ("Doc FIle: %s\n", fname);
  
  if ((id = edma_new_obj ("CLASS_METADATA")) == -1) 
    {
      g_print ("[ERROR] Can't create CLASS_METADATA Object");
      gnome_error_dialog ("Can't Create CLASS_METADATA Object. Aborting");
      gtk_widget_destroy (fs);
      return;    
    }

  build_metada_obj (id);

  if ((id1 = edma_new_obj("EDMA_DOC_BUILDER")) == -1) 
    {
      g_print ("[ERROR] Can't create EDMA_DOC_BUILDER Object");
      gnome_error_dialog ("Can't Create EDMA_DOC_BUILDER Object. Aborting");
      gtk_widget_destroy (fs);
      edma_free_obj (id);
      return;    
    }

  edma_met3(id1, "build", id, fname);
  edma_free_obj (id1);
  edma_free_obj (id);  
  gtk_widget_destroy (fs);  
}

/***********************************************************
 * Fills a CLASS_METADATA objet from app froms to pass it 
 * to builder objects
 ************************************************************/
int 
build_metada_obj(OBJID id)
{
  EPChar    temp[256], temp1[256], temp2[256];
  ESint32   i, j, n, v;

  /* General Information */
  GeneralGetClassName (&ggw, (EPChar) temp);
  edma_wprop3 (id, "ClassName", temp);
  GeneralGetTargetLanguage (&ggw, (EPChar) temp);
  edma_wprop3 (id, "Language", temp);

  GeneralGetNameSpace (&ggw, (EPChar) temp);
  edma_wprop3 (id, "NameSpace", temp);

  edma_wprop3 (id, "MajorVersion", GeneralGetMajorVersion (&ggw));
  edma_wprop3 (id, "MinorVersion", GeneralGetMinorVersion (&ggw));

  GeneralGetMachine (&ggw, (EPChar) temp);
  edma_wprop3 (id, "Machine", temp);

  GeneralGetOS (&ggw, (EPChar) temp);
  edma_wprop3 (id, "OperatingSystem", temp);

  GeneralGetModuleName (&ggw, (EPChar) temp);
  edma_wprop3 (id, "ModuleName", temp);

  GeneralGetSIUProxy (&ggw, (EPChar) temp);
  edma_wprop3 (id, "SIUProxy", temp);

  GeneralGetIDFParser (&ggw, (EPChar) temp);
  edma_wprop3 (id, "IDFParser", temp);

  i = GeneralGetIsProxy (&ggw);
  g_print ("Setting IsSIUProxy...\n");
  edma_wprop3 (id, "IsSIUProxy", i);

  i = GeneralGetIsParser (&ggw);
  edma_wprop3 (id, "IsIDFParser", i);

  i = GeneralGetIsEMI (&ggw);
  edma_wprop3 (id, "IsEMI", i);

  /* Superclasses */
  n = InhGetNSC (&giw);
  edma_met3 (id, "SetNSC", n);
  if (n) 
    {
      for (i = 0; i < n; i++) 
	{
	  InhGetSC (&giw, i, (EPChar) temp);
	  edma_met3 (id, "AddSC", temp);
      }
  }
  
  /* Properties */
  n = PropGetNP(&gpw);
  edma_met3 (id, "SetNProp", n);
  for (i = 0; i < n; i++) 
    {
      PropGetName   (&gpw, i, (EPChar) temp);
      PropGetType   (&gpw, i, (EPChar) temp1);
      PropGetAccess (&gpw, i, (EPChar) temp2);
      j = PropGetArray (&gpw, i);
      edma_met3 (id, "AddProp", temp, temp1, temp2, j);
    }
  
  /* Methods*/
  n = MetGetNM(&gmw) ;
  edma_met3 (id, "SetNMet", n);
  for (i = 0; i < n; i++)
    {
      MetGetName (&gmw, i, (EPChar) temp);
      MetGetSignature (&gmw, i, (EPChar) temp1);
      edma_met3 (id, "AddMet", temp, temp1,
		 MetGetVirtual  (&gmw, i), 
		 MetGetAbstract (&gmw, i),
		 MetGetStatic   (&gmw, i));

    }
  edma_met3 (id, "Show");
  return id;
}
