/*
  EDMA IDFWizard GNOMIZED Version 0.5.0
  Copyright (C) 1998,1999,2002,2005 David Martnez Oliveira
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
 */
/*
 * Revisions:
 * November, 17th, 2001
 * Removing compile warnnings and code cleanup
 * ----------------------------------------------------
 * May, 2nd, 2002
 * Adding NameSpace support
 * ----------------------------------------------------------
 * July, 20th, 2002
 * Adding versionong support
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>
#include <gnome.h>

#include <edma.h>

#include "generalform.h"


ESint32 
InitGeneralForm (GeneralWidgets *gw)
{
  OBJID    id;
  CLASSID  idC;
  EUint32  i, n;
  EChar    fname[1024], temp[200], temp1[200], *aux;

  gw->build_form = BuildGeneralForm;
  /* Init lists */
  gw->languages = NULL;
  /* Read Language supported using ID */
  
  g_print ("[DEBUG] About to create ID object\n");
  if ((id = edma_new_obj("ID")) == -1)
    {
      g_print ("[ERROR] (InitGeneralForm)Can't create ID object\n");
      exit(1);
    }
  
  memset (fname, 0, 1024);
  aux = edma_get_system_path (fname);
  strcpy (fname, aux);
  
  g_print ("System Path : %s\n",fname);
  
  strcat (fname, "/share/edma/languages_imp.db");
  
  edma_met3 (id, "SetDB", fname);
  edma_rprop3 (id, "nElems", &gw->n);

  for (i = 0; i < gw->n; i++)
    {
      edma_met3 (id,"GetItem",i, 
		 gw->lang_imp_classes[i], temp, gw->lang_desc[i]);
      gw->languages = g_list_append (gw->languages, gw->lang_desc[i]);
    }
  edma_free_obj( id);
  
  id = edma_new_obj ("ID");
  strcpy (fname, aux);
  g_print ("System Path : %s\n",fname);
  strcat (fname, "/share/edma/languages_make.db");
  edma_met3 (id, "SetDB", fname);
  edma_rprop3 (id, "nElems", &gw->n);
  for (i = 0; i < gw->n; i++)
    {
      edma_met3(id,"GetItem", i, gw->lang_make_classes[i], temp, temp1);
    }
  edma_free_obj (id);
  free (aux); 

  /* Language Processing done */
  gw->sos = NULL;
  gw->sos = g_list_append (gw->sos, "LINUX");
  gw->sos = g_list_append (gw->sos, "Windows 95/98");  

  gw->machines = NULL;
  gw->machines = g_list_append (gw->machines, "i386");
  gw->machines = g_list_append (gw->machines, "i486");
  gw->machines = g_list_append (gw->machines, "Pentium");
  gw->machines = g_list_append (gw->machines, "K6");

  gw->proxies = NULL;
  gw->proxies = g_list_append (gw->proxies, "NONE");

  gw->parsers = NULL;

  n = edma_ingridf_get_num_parsers ();
  /* Default parser always available*/
  g_print ("%d parsers in system...\n", n);
  gw->parsers = g_list_append (gw->parsers, "EDMAIDF");

  for (i = 1; i < edma_ingridf_get_num_parsers(); i++) 
    {
      idC = edma_ingridf_get_parser_class (i);
      edma_get_class_name (idC, temp);
      g_print ("Parser %d: %s [%d]\n", i, temp, idC);
      aux=strdup (temp);
      gw->parsers = g_list_append (gw->parsers, aux);
    }
  printf ("[DEBUG] General Form succesfully initiated\n");
}

ESint32 
BuildGeneralForm (GeneralWidgets *gw,GtkWidget *note)
{   
  GtkWidget *label, *aux;

  /* General Info Page */
  gw->table = gtk_table_new (14,2,FALSE);
  /* Label for options */
  label = gtk_label_new ("Class Name");
  gtk_widget_show (label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 0, 1);

  label = gtk_label_new ("Module Name");
  gtk_widget_show (label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 1, 2);

  label = gtk_label_new ("Name Space");
  gtk_widget_show(label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 2, 3);

  label = gtk_label_new ("Target Language");
  gtk_widget_show (label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 3, 4);

  label = gtk_label_new ("Operating System");
  gtk_widget_show (label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 4, 5);

  label = gtk_label_new ("Machine");
  gtk_widget_show (label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 5, 6);

  label = gtk_label_new ("SIU Proxy");
  gtk_widget_show (label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 6, 7);

  label = gtk_label_new ("IDF Parser");
  gtk_widget_show (label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 7, 8);

  label = gtk_label_new ("Major Version");
  gtk_widget_show (label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 11, 12);

  label = gtk_label_new ("Major Version");
  gtk_widget_show (label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 12, 13);

  /* Entry widgets */
  gw->ClassName = gtk_entry_new ();
  gtk_widget_show (gw->ClassName);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->ClassName, 1, 2, 0, 1);

  gw->ModuleName = gtk_entry_new ();
  gtk_widget_show (gw->ModuleName);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->ModuleName, 1, 2, 1, 2);
 
  gw->NameSpace = gtk_entry_new ();
  gtk_widget_show (gw->NameSpace);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->NameSpace, 1, 2, 2, 3);

 
  gw->TargetLanguage = gtk_combo_new();
  gtk_combo_set_popdown_strings (GTK_COMBO(gw->TargetLanguage), gw->languages);
  gtk_widget_show (gw->TargetLanguage);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->TargetLanguage, 
			     1, 2, 3, 4);
  
  gw->OS = gtk_combo_new();
  gtk_combo_set_popdown_strings (GTK_COMBO(gw->OS), gw->sos);
  gtk_widget_show (gw->OS);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->OS, 1, 2, 4, 5);
    
  gw->Machine = gtk_combo_new();
  gtk_combo_set_popdown_strings (GTK_COMBO(gw->Machine), gw->machines);
  gtk_widget_show (gw->Machine);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->Machine, 1, 2, 5, 6);
  
  gw->SIUProxy = gtk_combo_new();
  gtk_combo_set_popdown_strings (GTK_COMBO(gw->SIUProxy), gw->proxies);
  gtk_widget_show (gw->SIUProxy);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->SIUProxy, 1, 2, 6, 7);
  
  gw->IDFParser = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO(gw->IDFParser), gw->parsers);
  gtk_widget_show (gw->IDFParser);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->IDFParser, 1, 2, 7, 8);

  gw->IsSIUProxy = gtk_check_button_new_with_label ("IsSIUProxy");
  gtk_widget_show (gw->IsSIUProxy);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->IsSIUProxy, 1, 2, 8, 9);

  gw->IsIDFParser = gtk_check_button_new_with_label ("IsIDFParser");
  gtk_widget_show (gw->IsIDFParser);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->IsIDFParser, 
			     1, 2, 9, 10);


  gw->IsEMI = gtk_check_button_new_with_label ("IsEMI");
  gtk_widget_show (gw->IsEMI);  
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->IsEMI, 1, 2, 10, 11);

  gw->MajorVersion = gtk_entry_new ();
  gtk_widget_show (gw->MajorVersion);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->MajorVersion, 
			     1, 2, 11, 12);

  gw->MinorVersion = gtk_entry_new ();
  gtk_widget_show (gw->MinorVersion);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->MinorVersion, 
			     1, 2, 12, 13);

  gtk_widget_show (gw->table);

  label = gtk_label_new ("General");
  gtk_notebook_insert_page (GTK_NOTEBOOK (note), gw->table, label, 0);

  printf ("[DEBUG] General form succesfully created\n");
  return 0;
}

ESint32 
GeneralGetClassName(GeneralWidgets *gw,EPChar r)
{
  EPChar temp;

  temp = gtk_entry_get_text (GTK_ENTRY(gw->ClassName));
  strcpy (r, temp);
  return strlen (temp);
}

ESint32 
GeneralSetClassName(GeneralWidgets *gw, EPChar r)
{
  gtk_entry_set_text (GTK_ENTRY(gw->ClassName), r);
  return 0;
}


ESint32 
GeneralGetNameSpace(GeneralWidgets *gw, EPChar r)
{
  EPChar temp;

  temp = gtk_entry_get_text (GTK_ENTRY(gw->NameSpace));
  strcpy (r, temp);
  return strlen (temp);
}

ESint32 
GeneralSetMajorVersion (GeneralWidgets *gw, ESint32 v)
{
  EChar temp[10];

  sprintf (temp, "%d", v);
  gtk_entry_set_text (GTK_ENTRY(gw->MajorVersion), temp);
  return 0;
}

ESint32 
GeneralSetMinorVersion (GeneralWidgets *gw, ESint32 v)
{
  EChar temp[10];

  sprintf (temp, "%d", v);
  gtk_entry_set_text (GTK_ENTRY(gw->MinorVersion),temp);

  return 0;
}

ESint32 
GeneralSetNameSpace(GeneralWidgets *gw, EPChar r)
{
  gtk_entry_set_text (GTK_ENTRY(gw->NameSpace), r);
  return 0;
}

ESint32 
GeneralGetModuleName(GeneralWidgets *gw, EPChar r)
{
  EPChar temp;

  temp = gtk_entry_get_text (GTK_ENTRY(gw->ModuleName));
  strcpy (r, temp);

  return strlen (temp);
}

ESint32 
GeneralSetModuleName(GeneralWidgets *gw, EPChar r)
{
  gtk_entry_set_text (GTK_ENTRY(gw->ModuleName), r);

  return 0;
}

ESint32 
GeneralGetTargetLanguage(GeneralWidgets *gw,EPChar r)
{
  EPChar temp;

  temp = gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->TargetLanguage)->entry));
  strcpy (r, temp);

  return strlen (temp);
}

ESint32 
GeneralGetOS(GeneralWidgets *gw, EPChar r)
{
  EPChar temp;

  temp = gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->OS)->entry));
  strcpy (r, temp);

  return strlen (temp);
}

ESint32 
GeneralGetMachine(GeneralWidgets *gw, EPChar r)
{
  EPChar temp;

  temp = gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->Machine)->entry));
  strcpy (r, temp);

  return strlen (temp);
}

ESint32 
GeneralGetSIUProxy(GeneralWidgets *gw, EPChar r)
{
  EPChar temp;

  temp = gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->SIUProxy)->entry));
  strcpy (r, temp);
  return strlen (temp);
}

ESint32 
GeneralGetIDFParser(GeneralWidgets *gw, EPChar r)
{
  EPChar temp;

  temp = gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->IDFParser)->entry));
  strcpy (r, temp);

  return strlen (temp);
}

ESint32 
GeneralGetIsProxy (GeneralWidgets *gw)
{
  return (GTK_TOGGLE_BUTTON (gw->IsSIUProxy)->active);
}

ESint32 
GeneralGetIsParser (GeneralWidgets *gw)
{
  return (GTK_TOGGLE_BUTTON (gw->IsIDFParser)->active);
}

ESint32 
GeneralGetIsEMI (GeneralWidgets *gw)
{
  return (GTK_TOGGLE_BUTTON (gw->IsEMI)->active);
}

ESint32 
GeneralGetMajorVersion (GeneralWidgets *gw)
{
  EPChar temp;

  temp = gtk_entry_get_text (GTK_ENTRY(gw->MajorVersion));
  return atol (temp);
}

ESint32 
GeneralGetMinorVersion (GeneralWidgets *gw)
{
  EPChar temp;

  temp = gtk_entry_get_text (GTK_ENTRY(gw->MinorVersion));
  return atol (temp);
}
