/*

    Routines to allocate structures describing the blocks which
    comprise the cube, and manipulating them, and querying their status.
    Copyright (C) 1998, 2003  John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#ifndef BLOCKS_H
#define BLOCKS_H
#include <stdlib.h>
#include "txfm.h"


#define FACE_0 0x01
#define FACE_1 0x02
#define FACE_2 0x04
#define FACE_3 0x08
#define FACE_4 0x10
#define FACE_5 0x20


/* Set the normal vector for block/face to v .
   This value gets transformed by the MODELVIEW CTM before saving.*/
void set_normal_vector(int block, int face,const vector v) ;

/* Set the vector for block/face/quadrant to v .
   This value gets transformed by the MODELVIEW CTM before saving.*/
void set_quadrant_vector(int block, int face, int quadrant, const vector v);

/* Get the direction vector for the block/face/quadrant */
void get_quadrant_vector(int block, int face, int quadrant, vector v);



/* Get the centre point of the face into p */
void get_face_centre(int block, int face, point p) ; 



/* return an int identifying all the visible faces in this block */
int get_visible_faces(int id) ;


/* Cube co-ordinates have their origin at the centre of the
cube, and their units are equivalent to one half of the length
of one edge of a block */

/* initialise the blocks to positions around the surface of the cube 
Returns the number of blocks created, or -1 on error.
*/
int create_blocks(int cube_dimension, int *block_qty );

/* return the tranformation of the specified block */
int get_block_transform( int id , Matrix transform);

/* return the block id whose centre  is located at position x,y,z */
int block_at_location(int x, int y, int z);

int get_number_of_blocks(void);

/*  Rotate a complete slice */
int rotate_slice(int block_id, int axis, int turns);

/* Return the identity of all the blocks in a particalar slice. 
block_qty is filled with the quantity of blocks, the return value
is a pointer to an array of block identies.  The memory for the 
returned identites is allocated by the function and remains valid
until the next call */
int *identify_blocks(int block_id, int axis , int *block_qty);

/* free up memory used by create_blocks */
void destroy_blocks(void);

/* print error messages generated by this library */
void bl_err(const char *s);

/* Show the Z,th Slice */
void showSlice(int z);

/* Print the Block to stdout */
void showBlock(int i);

enum cube_status { NOT_SOLVED=0, SOLVED, HALF_SOLVED };

/* Is the cube solved ? */
enum cube_status cubeStatusCheck(void);



#endif /* BLOCKS_H */
