/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2013, 2014, 2015, 2016, 2017, 2018 (c)
 * 
 *    file: help.c
 *    This file is part of Prime.
 *
 *    Prime is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Prime is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with Prime.  If not, see <http://www.gnu.org/licenses/>.
 */    

#include "defs.h"
#include "help.h"

////////////////////////////////////////////////////////
//shows a window with KEYBINDINGS file as its contents//
////////////////////////////////////////////////////////
void showKeybindings() 
{
  int res = show_readme("/usr/share/doc/gnudos/prime/keybindings", " KEYBINDINGS ", GNU_DOS_LEVEL);
  if(res != 0)
  {
    res = show_readme("/usr/local/share/doc/gnudos/prime/keybindings", " KEYBINDINGS ", GNU_DOS_LEVEL);
  }
  drawMenuBar(2, 2, SCREEN_W-2);	//draw main menu bar
  refreshBottomView();
  return;
}


/******************************************
 * this function shows a window with 
 * README file as its contents.
 * ****************************************/
void showReadMe() 
{
  int res = show_readme("/usr/share/doc/gnudos/prime/README", " README ", GNU_DOS_LEVEL);
  if(res != 0)
  {
    res = show_readme("/usr/local/share/doc/gnudos/prime/README", " README ", GNU_DOS_LEVEL);
  }
  drawMenuBar(2, 2, SCREEN_W-2);	//draw main menu bar
  refreshBottomView();
  return;
}

void showQuickReference()
{
    drawBox(3, 5, 18, SCREEN_W-5, "Quick Reference", YES);
    fprintf(stdout, "\e[4;7HBasic functions:");
    fprintf(stdout, "\e[5;9HSPACEBAR: Toggle select/unselect");
    fprintf(stdout, "\e[6;9HENTER: Navigate to directory");
    fprintf(stdout, "\e[7;9HTAB: Navigate between dir/file view windows");
    fprintf(stdout, "\e[8;9HArrow keys: Navigate up/down");
    fprintf(stdout, "\e[10;7HEditing:");
    fprintf(stdout, "\e[11;9HDEL: Delete marked directories/files");
    fprintf(stdout, "\e[12;9HCTRL+X: Cut marked directories/files");
    fprintf(stdout, "\e[13;9HCTRL+C: Copy marked directories/files");
    fprintf(stdout, "\e[14;9HCTRL+V: Paste marked directories/files");
    fprintf(stdout, "\e[15;9HCTRL+F: Find files");
    fprintf(stdout, "\e[16;9HCTRL+Q: Quit the program");
    fprintf(stdout, "\e[17;7HPress any key to continue..");
    fflush(stdout);
    do {;} while(!getKey());
}

void showAboutBox()
{
    show_about(copyright_notice);
}
