/* -*- Mode: c++ -*-
 *
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

/*
 * This program will do the following things in order
 * 1. convert the symbols from a.out --> 1 and 0 to '*' and '_'
 *    and store in the file b.out
 * 2. find the starting point of the data and record
 *    both "data" and "error" into the file c.out
 * 3. same as 2. but no "error" will be recorded to the file
 * 4. Decode the manchester decoding
 */


#include <iostream>
#include <fstream>
#include <cstdio>

using namespace std;

//procedure declaration
bool symbolConvert();
void sliceOnSymbol();
void findDottingSequence();
void findControlFiller();

//---------------------------------------------------------
//main program
int main() {

  if (!symbolConvert())
    return 1;
  sliceOnSymbol();
  findDottingSequence();
  findControlFiller();    
  return 0;
}

//---------------------------------------------------------
//convert symbol 
bool 
symbolConvert()
{

  ifstream inFile("a.out", ios::in);
  if (!inFile){
    perror ("a.out");
    return false;
  }

  ofstream outFile("b.out", ios::out);
  char ch;


  //convert 1 and 0 to '*' and '_'  
  while (inFile.get(ch)) {

    if (ch == '0') 
      outFile.put('_');
    else {
      if (ch == '1')
	outFile.put('*');
      else
	outFile.put(ch);
    }

  } //end of while loop

  inFile.close();
  outFile.close();
  return true;
}

//---------------------------------------------------------

void 
sliceOnSymbol() 
{
  int count0, count1,interval, sync;
  char ch;


    count0 =0;
    count1=0;
    interval =0;
    sync = 0;

    // algorithm to slice on symbol
    ifstream inFile("b.out", ios::in);
    ofstream outFile("d.out", ios::out);

    //synchronize
    while (inFile.get(ch))  {

      if (!sync) {
 
          if (ch == '*')
              count1 += 1;
          if (ch == '_')          
              count1 = 0;
         
          //change count1 to change the cutting rate. Default = 5;
          if (count1 == 3) {

              inFile.get(ch); 
              if (ch == '_') {
                  count0 =1;  
                  count1 =0;
                  sync = 1;
                  interval++;
                  cerr << endl << "got sync " << endl;

                  for (int i=0; i < 10; i++) 
                       outFile.put('#');

              } else {
                       count1 = 0;
	             }
          }


      } else { //the data has been sync
                          
                if (ch == '*') 
                    count1 +=1;     
                if (ch == '_')
                    count0 +=1; 
                if (ch == '\n')
                    interval--;

                interval++;

                //change interval to change the cutting rate. Default = 5
                if (interval == 3) {
                                          
		  //outFile.put(ch); //test 1 symbol per data bit

		    if (count0 > count1)
                        outFile.put('_');
                                
                    if (count1 > count0)
                        outFile.put('*'); 
		          
                    interval =0;
                    count0 = 0;
                    count1 = 0;
                }  //end if(interval==5)
             }  //end else
          
    } //end of while loop
 
    //slicing

    inFile.close();
    outFile.close();

}

//--------------------------------------------------------- 
void findDottingSequence() {

  
  char	ch;
  int bingo,index1;
  int size=20;
  char original[20] = {
                '_' , '*' , '*' , '_' , '_' , '*' , '*' ,
                '_', '_' , '*' , '*' , '_' , '_' , '*' , '*' , 
                '_', '_' , '*' , '*' , '_' ,

                //busy idle bit
		//  'x','x',
              
                //word sync
		// '*','_','*','_','_','*','_','*','_','*',
                //'*','_','_','*','_','*','*','_','_','*',
                //'*','_'
                    };

  int next=0;
  int keep=0;
  int wrong=0;

     bingo=0;
     index1=0;
     ifstream inFile("d.out", ios::in);

     while(inFile.get(ch)) {
       
         if(bingo >= 1) {
            next++;
            keep = bingo;
         }

         if (original[index1] == ch || original[index1] == 'x') 
	   //   if(original[index1] == ch)        
             index1++;                
         else 
             index1=0;
         
        
         if (index1 == size) {

          
             bingo++;
               
      
             wrong=0;
             index1 = 0;
         }
      
         if (keep != bingo) {

	   cerr << "interval is " << next << endl;
           next=0;
         } 

       }

       cerr << "There are total " << bingo << " dottings found\n";
       inFile.close();
      
  
}

//--------------------------------------------------------- 

void 
findControlFiller() 
{



  char ch;
  int  fillerSize=20;
  int  fillerIndex, bingo;
  char filler[20] = { //just check only the first 10 bit
    '_','*','_','*',
    'x','x','x','x',
    '*','_','_','*','*','_','_','*','_','*','_','*'
  }; 

     fillerIndex =0;
     bingo=0;
     ifstream inFile("d.out", ios::in);

     while(inFile.get(ch)) {
         if(filler[fillerIndex] == ch || filler[fillerIndex] == 'x')
            fillerIndex++;
         else
            fillerIndex=0;
     
          
         if(fillerIndex == fillerSize) {
              bingo++;
              fillerIndex=0; 
	 }  
     } //end of while

     cerr << endl << "There are " << bingo << " control filler messages\n";
}

//---------------------------------------------------------











