#!/usr/bin/env python
#
# Copyright 2004 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

from gnuradio import gr, gr_unittest
import math

class test_sig_source (gr_unittest.TestCase):

    def setUp (self):
        self.fg = gr.flow_graph ()

    def tearDown (self):
        self.fg = None

    def test_hilbert (self):
        fg = self.fg
        ntaps = 37
        sampling_freq = 100

        expected_result = (
            -0.951056361198 -0.307912647724j,
            -0.58778488636 -0.806124925613j,
            4.76837158203e-07 -0.996424913406j,
            0.587785661221 -0.806124448776j,
            0.951056659222 -0.30791169405j,
            0.951056361198 +0.307912737131j,
            0.587784826756 +0.806125044823j,
            -6.2783294652e-07 +0.996424913406j,
            -0.58778578043 +0.806124329567j,
            -0.951056718826 +0.307911574841j,
            -0.951056301594 -0.307912886143j)

        src1 = gr.sig_source_f (sampling_freq, gr.GR_SIN_WAVE,
                                sampling_freq * 0.10, 1.0)

        head = gr.head (gr.sizeof_float, int (ntaps + sampling_freq * 0.10))
        hilb = gr.hilbert_fc (ntaps)
        dst1 = gr.vector_sink_c ()
        fg.connect (src1, head)
        fg.connect (head, hilb)
        fg.connect (hilb, dst1)
        fg.run ()
        dst_data = dst1.data ()
        self.assertComplexTuplesAlmostEqual (expected_result, dst_data, 5)

if __name__ == '__main__':
    gr_unittest.main ()
