#
# Copyright 2004 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

# This is the "generic" audio or soundcard interface.
# We try loading hardware specific modules until we find one that works
# or we run out of ideas...

# we should probably rewrite this to scan the gnuradio directory for
# audio_*.py files and use the __import__ function to import them.
# Checking for a user specified preference probably isn't a bad idea either


__all__ = ['source', 'sink']

source = None
sink = None

verbose = False

def __init__ ():
    global source, sink
    try:
        import gnuradio.audio_alsa
        source = gnuradio.audio_alsa.source
        sink = gnuradio.audio_alsa.sink
        if verbose: print "audio: using audio_alsa"
    except ImportError:
        try:
            import gnuradio.audio_oss
            source = gnuradio.audio_oss.source
            sink = gnuradio.audio_oss.sink
            if verbose: print "audio: using audio_oss"
        except ImportError:
            try:
                import gnuradio.audio_osx
                source = gnuradio.audio_osx.source
                sink = gnuradio.audio_osx.sink
                if verbose: print "audio: using audio_osx"
            except ImportError:
                try:
                    import gnuradio.audio_windows
                    source = gnuradio.audio_windows.source
                    sink = gnuradio.audio_windows.sink
                    if verbose: print "audio: using audio_windows"
                except ImportError:
                    raise ImportError, 'Unable to locate an audio module.'

__init__ ()
