/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.kawa.lispexpr.ReaderXmlElement;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Namespace;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class ResolveNamespace
extends Syntax {
    public static final ResolveNamespace resolveNamespace = new ResolveNamespace("$resolve-namespace$", false);
    public static final ResolveNamespace resolveQName = new ResolveNamespace("$resolve-qname$", true);
    boolean resolvingQName;

    public ResolveNamespace(String name, boolean resolvingQName) {
        super(name);
        this.resolvingQName = resolvingQName;
    }

    @Override
    public Expression rewriteForm(Pair form, Translator tr) {
        Expression prefix;
        Namespace namespace;
        String local;
        Pair pair;
        Object cdr = form.getCdr();
        if (this.resolvingQName) {
            pair = (Pair)cdr;
            local = pair.getCar().toString();
            cdr = pair.getCdr();
        } else {
            local = null;
        }
        if (!(cdr instanceof Pair)) {
            cdr = LList.list1(ReaderXmlElement.defaultElementNamespaceSymbol);
        }
        if ((namespace = tr.namespaceResolvePrefix(prefix = tr.rewrite_car(pair = (Pair)cdr, false))) == null) {
            String pstr = pair.getCar().toString();
            if (pstr == "$default-element-namespace$") {
                namespace = Namespace.EmptyNamespace;
            } else {
                Object savePos = tr.pushPositionOf(pair);
                tr.error('e', "unknown namespace prefix " + pstr);
                tr.popPositionOf(savePos);
                namespace = Namespace.valueOf(pstr, pstr);
            }
        }
        if (this.resolvingQName) {
            return new QuoteExp(namespace.getSymbol(local));
        }
        return new QuoteExp(namespace);
    }
}

