/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Expression;
import gnu.expr.Keyword;
import gnu.expr.Language;
import gnu.expr.Mangling;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.TypeValue;
import gnu.kawa.lispexpr.ClassNamespace;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.CompileInvoke;
import gnu.kawa.reflect.SlotSet;
import gnu.lists.FVector;
import gnu.mapping.ArgListVector;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.WrongType;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;

public class Invoke
extends Procedure {
    char kind;
    Language language;
    static final MethodHandle applyToObject = Invoke.lookupApplyHandle(Invoke.class, "applyToObject");
    public static final Invoke invoke = new Invoke("invoke", '*');
    public static final Invoke invokeStatic = new Invoke("invoke-static", 'S');
    public static final Invoke invokeSpecial = new Invoke("invoke-special", 'P');
    public static final Invoke make = new Invoke("make", 'N');

    public Invoke(String name, char kind) {
        this(name, kind, Language.getDefaultLanguage());
    }

    public Invoke(String name, char kind, Language language) {
        super(false, applyToObject, name);
        this.kind = kind;
        this.language = language;
        this.setProperty(Procedure.validateXApplyKey, "gnu.kawa.reflect.CompileInvoke:validateApplyInvoke");
    }

    public static Object invoke$V(Object[] args) throws Throwable {
        return invoke.applyN(args);
    }

    public static Object invokeStatic$V(Object[] args) throws Throwable {
        return invokeStatic.applyN(args);
    }

    public static Object make$V(Object[] args) throws Throwable {
        return make.applyN(args);
    }

    private static ObjectType typeFrom(Object arg, Invoke thisProc) {
        if (arg instanceof Class) {
            arg = Type.make((Class)arg);
        }
        if (arg instanceof ObjectType) {
            return (ObjectType)arg;
        }
        if (arg instanceof CharSequence) {
            return ClassType.make(arg.toString());
        }
        if (arg instanceof Symbol) {
            return ClassType.make(((Symbol)arg).getName());
        }
        if (arg instanceof ClassNamespace) {
            return ((ClassNamespace)arg).getClassType();
        }
        throw new WrongType((Procedure)thisProc, 0, arg, "class-specifier");
    }

    public static Object applyToObject(Procedure proc, CallContext ctx) throws Throwable {
        int i;
        Object result;
        Object mname;
        ObjectType dtype;
        Invoke invoke = (Invoke)proc;
        char kind = invoke.kind;
        Language language = invoke.language;
        if (kind == 'P') {
            throw new RuntimeException(invoke.getName() + ": invoke-special not allowed at run time");
        }
        int nargs = ctx.numArguments();
        Procedure.checkArgCount(invoke, nargs);
        Object arg0 = ctx.getArgAsObject(0);
        ObjectType objectType = dtype = kind != 'V' && kind != '*' ? Invoke.typeFrom(arg0, invoke) : (ObjectType)Type.make(arg0.getClass());
        if (kind == 'N') {
            Procedure constructor;
            mname = null;
            if (dtype instanceof TypeValue && (constructor = ((TypeValue)((Object)dtype)).getConstructor()) != null) {
                return constructor.applyL(ArgListVector.drop(ctx, 1));
            }
            if (dtype instanceof PairClassType) {
                PairClassType ptype = (PairClassType)dtype;
                dtype = ptype.instanceType;
            }
            if (dtype instanceof ArrayType || dtype == LangObjType.constVectorType) {
                int len;
                int length = len = ctx.numArguments() - 1;
                boolean lengthSpecified = false;
                ClassType elementType = dtype == LangObjType.constVectorType ? Type.objectType : ((ArrayType)dtype).getComponentType();
                Object arr = Array.newInstance(((Type)elementType).getReflectClass(), length);
                int index = 0;
                for (int i2 = 1; i2 <= len; ++i2) {
                    String kname;
                    Object arg = ctx.getArgAsObject(i2);
                    if (lengthSpecified && (kname = ctx.getKeyword(i2)) != null) {
                        try {
                            index = Integer.parseInt(kname);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("non-integer keyword '" + kname + "' in array constructor");
                        }
                    }
                    Array.set(arr, index, ((Type)elementType).coerceFromObject(arg));
                    ++index;
                }
                if (dtype == LangObjType.constVectorType) {
                    return FVector.makeConstant((Object[])arr);
                }
                return arr;
            }
        } else {
            mname = ctx.getArgAsObject(1);
        }
        MethodProc mproc = invoke.lookupMethods(dtype, mname);
        if (kind != 'N') {
            ArgListVector margs = ArgListVector.drop(ctx, 2);
            if (kind == 'V' || kind == '*') {
                margs = ArgListVector.prepend(margs, ctx.getArgAsObject(0));
            }
            return mproc.applyL(margs);
        }
        ArgListVector args = ArgListVector.drop(ctx, 0);
        int keywordStart = ctx.firstKeyword();
        if (ctx.numKeywords() == 0) {
            ctx.rewind(1);
            Object r = mproc.getApplyToObjectMethod().invokeExact(mproc, ctx);
            if (r != ctx) {
                return r;
            }
            MethodProc vproc = ClassMethods.apply(dtype, "valueOf", '\u0000', language);
            if (vproc != null) {
                ctx.setupApply(vproc);
                ctx.addAll(ArgListVector.drop(args, 1));
                ctx.rewind(1);
                r = ctx.runUntilValue();
                if (r != ctx) {
                    return r;
                }
            }
            result = mproc.apply1(args.getArgAsObject(0));
        } else {
            Object[] cargs = new Object[keywordStart];
            for (int i3 = 0; i3 < keywordStart; ++i3) {
                cargs[i3] = args.getArgAsObject(i3);
            }
            result = mproc.applyN(cargs);
        }
        int numKeys = args.numKeywords();
        for (i = 0; i < numKeys; ++i) {
            Object arg = args.getArgAsObject(keywordStart + i);
            Keyword key = Keyword.make(args.getKeyword(keywordStart + i));
            SlotSet.apply(false, result, key.getName(), arg);
        }
        int n = i = numKeys == 0 ? 1 : keywordStart + numKeys;
        if (i != nargs) {
            MethodProc aproc = ClassMethods.apply(dtype, "add", '\u0000', language);
            int err = -1;
            if (aproc == null) {
                throw MethodProc.matchFailAsException(err, proc, args);
            }
            while (i < nargs) {
                aproc.apply2(result, args.getArgAsObject(i++));
            }
        }
        return result;
    }

    @Override
    public int numArgs() {
        return 0xFFFFF000 | (this.kind == 'N' ? 1 : 2);
    }

    protected MethodProc lookupMethods(ObjectType dtype, Object name) {
        String mname;
        if (this.kind == 'N') {
            mname = "<init>";
        } else {
            if (name instanceof CharSequence) {
                mname = name.toString();
            } else if (name instanceof Symbol) {
                mname = ((Symbol)name).getName();
            } else {
                throw new WrongType((Procedure)this, 1, name, "string-or-symbol");
            }
            mname = Mangling.mangleName(mname);
        }
        MethodProc proc = ClassMethods.apply(dtype, mname, (char)(this.kind == 'P' ? 80 : (this.kind == '*' || this.kind == 'V' ? 86 : 0)), this.language);
        if (proc == null) {
            throw new RuntimeException(this.getName() + ": no method named `" + mname + "' in class " + dtype.getName());
        }
        return proc;
    }

    public static synchronized ApplyExp makeInvokeStatic(ClassType type, String name, Expression ... args) {
        PrimProcedure method = Invoke.getStaticMethod(type, name, args);
        if (method == null) {
            throw new RuntimeException("missing or ambiguous method `" + name + "' in " + type.getName());
        }
        return new ApplyExp(method, args);
    }

    @Deprecated
    public static synchronized PrimProcedure getStaticMethod(ClassType type, String name, Expression[] args) {
        return CompileInvoke.getStaticMethod(type, name, args);
    }
}

