/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.expr.Keyword;
import gnu.lists.FVector;
import gnu.mapping.ArgList;
import gnu.mapping.ArgListImpl;
import gnu.mapping.CallContext;

public class ArgListVector
extends FVector
implements ArgList {
    private int firstKeyword;
    private int numKeywords;

    public ArgListVector(Object[] args, int firstKeyword, int numKeywords) {
        super(args);
        this.firstKeyword = firstKeyword;
        this.numKeywords = numKeywords;
        this.setReadOnly();
    }

    public static ArgListVector getArgs(CallContext ctx) {
        return ArgListVector.drop(ctx, 0);
    }

    public static ArgListVector prepend(ArgListVector args, Object ... extra) {
        int xlen = extra.length;
        int n = args.size();
        Object[] vals = new Object[xlen + n];
        for (int i = 0; i < n; ++i) {
            vals[xlen + i] = args.get(i);
        }
        System.arraycopy(extra, 0, vals, 0, xlen);
        return new ArgListVector(vals, args.firstKeyword() + xlen, args.numKeywords());
    }

    public static ArgListVector drop(ArgList args, int toSkip) {
        int newFirst;
        int skipKeys;
        int i;
        int numKeywords = args.numKeywords();
        int firstKeyword = args.firstKeyword();
        int count = args.numArguments();
        int size = numKeywords + count - toSkip;
        Object[] vals = new Object[size];
        if (toSkip <= firstKeyword) {
            i = toSkip;
            skipKeys = 0;
            newFirst = firstKeyword - toSkip;
        } else if (toSkip >= firstKeyword + 2 * numKeywords) {
            i = toSkip - numKeywords;
            skipKeys = numKeywords;
            newFirst = 0;
        } else {
            int skipKeys2 = toSkip - firstKeyword;
            skipKeys = skipKeys2 + 1 >> 1;
            i = firstKeyword + skipKeys;
            newFirst = skipKeys2 & 1;
            if (newFirst != 0) {
                ++firstKeyword;
                --numKeywords;
                --i;
            }
        }
        int j = 0;
        while (j < size) {
            if (i >= firstKeyword && i < firstKeyword + numKeywords) {
                vals[j++] = Keyword.make(args.getKeyword(i));
            }
            vals[j++] = args.getArgAsObject(i);
            ++i;
        }
        return new ArgListVector(vals, newFirst, numKeywords - skipKeys);
    }

    @Override
    public int numArguments() {
        return this.size() - this.numKeywords;
    }

    @Override
    public Object getArgAsObject(int i) {
        if (i < this.firstKeyword) {
            return this.get(i);
        }
        if (i >= this.firstKeyword + this.numKeywords) {
            return this.get(i + this.numKeywords);
        }
        return this.get(2 * i - this.firstKeyword + 1);
    }

    @Override
    public String getKeyword(int i) {
        if (i < this.firstKeyword || i >= this.firstKeyword + this.numKeywords) {
            return null;
        }
        return ((Keyword)this.get(2 * i - this.firstKeyword)).getName();
    }

    @Override
    public int numKeywords() {
        return this.numKeywords;
    }

    @Override
    public int firstKeyword() {
        return this.firstKeyword;
    }

    @Override
    public int findKeyword(String key) {
        return ArgListImpl.findKeyword(this, key);
    }
}

