/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.SourceError;
import gnu.text.SourceLocator;

public class SourceMessages
extends SourceLocator.Simple {
    private int errorCount = 0;
    SourceError firstError;
    SourceError lastError;
    SourceLocator locator;
    public static boolean stripDirectoriesDefault = false;
    public boolean stripDirectories = stripDirectoriesDefault;
    public static boolean debugStackTraceOnWarning = false;
    public static boolean debugStackTraceOnError = false;
    SourceError lastPrevFilename = null;
    public boolean sortMessages;

    public SourceError getErrors() {
        return this.firstError;
    }

    public boolean seenErrors() {
        return this.errorCount > 0;
    }

    public boolean seenErrorsOrWarnings() {
        return this.firstError != null;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getCount(String severities) {
        int count = 0;
        SourceError err = this.firstError;
        while (err != null) {
            if (severities.indexOf(err.severity) >= 0) {
                ++count;
            }
            err = err.next;
        }
        return count;
    }

    public void clearErrors() {
        this.errorCount = 0;
    }

    public void clear() {
        this.lastError = null;
        this.firstError = null;
        this.errorCount = 0;
    }

    public void error(SourceError error) {
        if (error.severity == 'f') {
            this.errorCount = 1000;
        } else if (error.severity != 'w' && error.severity != 'i') {
            ++this.errorCount;
        }
        if (error.fakeException == null && (debugStackTraceOnError && (error.severity == 'e' || error.severity == 'f') || debugStackTraceOnWarning && error.severity == 'w')) {
            error.fakeException = new Throwable();
        }
        if (this.lastError != null && this.lastError.filename != null && !this.lastError.filename.equals(error.filename)) {
            this.lastPrevFilename = this.lastError;
        }
        SourceError prev = this.lastPrevFilename;
        if (!this.sortMessages || error.severity == 'f') {
            prev = this.lastError;
        } else {
            SourceError next;
            while ((next = prev == null ? this.firstError : prev.next) != null) {
                int errline = error.getStartLine();
                int nextline = next.getStartLine();
                if (errline != 0 && nextline != 0) {
                    if (errline < nextline) break;
                    if (errline == nextline) {
                        int errcol = error.getStartColumn();
                        int nextcol = next.getStartColumn();
                        if (errcol > 0 && nextcol > 0 && errcol < nextcol) break;
                    }
                }
                prev = next;
            }
        }
        if (prev == null) {
            error.next = this.firstError;
            this.firstError = error;
        } else {
            error.next = prev.next;
            prev.next = error;
        }
        if (prev == this.lastError) {
            this.lastError = error;
        }
    }

    public void error(char severity, String filename, int line, int column, String message) {
        this.error(new SourceError(severity, filename, line, column, message));
    }

    public void error(char severity, SourceLocator location2, String message) {
        this.error(new SourceError(severity, location2, message));
    }

    public void error(char severity, String filename, int line, int column, String message, String code) {
        SourceError err = new SourceError(severity, filename, line, column, message);
        err.code = code;
        this.error(err);
    }

    public void error(char severity, SourceLocator location2, String message, String code) {
        SourceError err = new SourceError(severity, location2, message);
        err.code = code;
        this.error(err);
    }

    public void error(char severity, String message) {
        this.error(new SourceError(severity, this, message));
    }

    public void error(char severity, String message, Throwable exception) {
        SourceError err = new SourceError(severity, this, message);
        err.fakeException = exception;
        this.error(err);
    }

    public void error(char severity, String message, String code) {
        SourceError err = new SourceError(severity, this, message);
        err.code = code;
        this.error(err);
    }

    public void printAll(Appendable out, int max) {
        int errCount = this.getCount("ef");
        int wrnCount = this.getCount("iw");
        int errLimit = max >= 0 && errCount > max ? max : errCount;
        int wrnLimit = max >= 0 && errCount + wrnCount > max ? max - errLimit : wrnCount;
        int skippedErrors = 0;
        int skippedWarnings = 0;
        int skippedInfo = 0;
        SourceError err = this.firstError;
        while (err != null) {
            if (err.severity == 'e' && --errLimit < 0) {
                ++skippedErrors;
            } else if (err.severity == 'w' && --wrnLimit < 0) {
                ++skippedWarnings;
            } else if (err.severity == 'i' && --wrnLimit < 0) {
                ++skippedInfo;
            } else {
                err.println(out, this.stripDirectories);
            }
            err = err.next;
        }
        if (skippedErrors + skippedWarnings + skippedInfo > 0) {
            err = new SourceError('i', this.firstError.getFileName(), 0, 0, "skipped " + skippedErrors + " errors, " + skippedWarnings + " warnings, " + skippedInfo + " notes");
            err.println(out, this.stripDirectories);
        }
    }

    public String toString(int max) {
        if (this.firstError == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        SourceError err = this.firstError;
        while (err != null && --max >= 0) {
            err.appendTo(buffer, this.stripDirectories, "\n");
            err = err.next;
        }
        return buffer.toString();
    }

    public boolean checkErrors(Appendable out, int max) {
        if (this.firstError != null) {
            this.printAll(out, max);
            this.lastError = null;
            this.firstError = null;
            int saveCount = this.errorCount;
            this.errorCount = 0;
            return saveCount > 0;
        }
        return false;
    }

    public final void setSourceLocator(SourceLocator locator) {
        this.locator = locator == this ? null : locator;
    }

    public final SourceLocator swapSourceLocator(SourceLocator locator) {
        SourceLocator save = this.locator;
        this.locator = locator;
        return save;
    }

    @Override
    public final void setLocation(SourceLocator locator) {
        this.locator = null;
        super.setLocation(locator);
    }

    @Override
    public String getPublicId() {
        return this.locator == null ? super.getPublicId() : this.locator.getPublicId();
    }

    @Override
    public String getSystemId() {
        return this.locator == null ? super.getSystemId() : this.locator.getSystemId();
    }

    @Override
    public boolean isStableSourceLocation() {
        return false;
    }

    @Override
    public final String getFileName() {
        return this.locator == null ? super.getFileName() : this.locator.getFileName();
    }

    @Override
    public final int getLineNumber() {
        return this.locator == null ? super.getLineNumber() : this.locator.getLineNumber();
    }

    @Override
    public final int getColumnNumber() {
        return this.locator == null ? super.getColumnNumber() : this.locator.getColumnNumber();
    }

    @Override
    public int getStartLine() {
        return this.locator == null ? super.getStartLine() : this.locator.getStartLine();
    }

    @Override
    public int getStartColumn() {
        return this.locator == null ? super.getStartColumn() : this.locator.getStartColumn();
    }

    @Override
    public int getEndLine() {
        return this.locator == null ? super.getEndLine() : this.locator.getEndLine();
    }

    @Override
    public int getEndColumn() {
        return this.locator == null ? super.getEndColumn() : this.locator.getEndColumn();
    }

    public void setColumn(int column) {
        this.setLine(this.getLineNumber(), column);
    }
}

