"======================================================================
|
|   Smalltalk GUI inspector for CompiledMethods
|
|
 ======================================================================"


"======================================================================
|
| Copyright 1992,94,95,99,2000,2001,2002 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

GenericInspector subclass:  #MethodInspector
	instanceVariableNames: 'lastVar '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Browser'
!

!MethodInspector methodsFor: 'initializing'!

inspectMenu: listView
"Initialize menu for variable list pane"
    ^((PopupMenu new: listView label: '') selectors:
#(('Inspect' #evalAndInspectResult: #listView) ('References' #references: #listView))
					  receiver: self
					  argument: listView ).
! !

!MethodInspector methodsFor: 'private'!

currentVariableValue
    | s |
    currentVariable == 0 ifTrue: [ ^nil ].
    currentVariable = 1 ifTrue: [
	s := WriteStream on: (String new: 100).
	theObject printHeaderOn: s.
	^s contents
    ].
    currentVariable = lastVar ifTrue: [
	s := WriteStream on: (String new: 100).
	theObject printByteCodesOn: s.
	^s contents
    ].
    ^currentVariable < lastVar
	ifTrue: [ theObject instVarAt: currentVariable + 1 ]
	ifFalse: [ theObject literalAt: currentVariable - lastVar].
!

text
"Return string representation of currently selected instance or indexed 
variable"
	^currentVariable == 0
		ifTrue: [ '' ]
		ifFalse: [ self currentVariableValue displayString ].
!

currentVariable: obj
    Blox beep
!

setInstanceVars: anObject
"Initialize instance variable, instVars, which governs display of
variable list pane."
    | string instVarNames |
    theObject := anObject.
    instVarNames := theObject class allInstVarNames.
    instVars add: 'header'.
    3 to: instVarNames size do: [ :x |
	string := (instVarNames at: x) asString.
	instVars add: string.
    ].
    instVars add: 'bytecodes'.
    lastVar := instVars size.
    1 to: theObject numLiterals do:
	[ :x | instVars add: x printString].
! !

!MethodInspector methodsFor: 'variable list menu'!

references: listView
"Open a method set browser on all methods which reference selected key"
    | alert keyRefs theKey |
    currentVariable isNil ifTrue: [^listView beep].
    currentVariable <= lastVar ifTrue: [^listView beep].
    keyRefs := SortedCollection new.
    Namespace current allClassObjectsDo: 
	[:subclass | (subclass whichSelectorsReferTo: 
			  (theObject literalAt: currentVariable)) do: 
			      [ :sel | keyRefs add: ( subclass printString , ' ', sel )]].
    keyRefs isEmpty ifTrue: [^alert := ModalDialog new alertMessage: 
				 'No references to ', (currentVariable printString) in: listView]. 
    MethodSetBrowser new openOn: keyRefs title: 'References to ', 
	(currentVariable printString)  selection: (currentVariable displayString).
! !

! CompiledCode methodsFor: 'debugging' !

inspect
"Open a MethodInspector window on self"
    BLOX BLOXBrowser MethodInspector new openOn: self
!

inspect: pane
"Open a MethodInspector window on self"
    BLOX BLOXBrowser MethodInspector new openOn: self in: pane
! !
