"======================================================================
|
|   SUnit testing framework - tests
|
|   This file is in the public domain.
|
 ======================================================================"

TestCase subclass: #SUnitTest
	instanceVariableNames: 'hasRun '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SUnitTests'!

SUnitTest class
	instanceVariableNames: ''!

TestCase subclass: #SUnitClientTest
	instanceVariableNames: 'hasRun hasSetup '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SUnitTests'!

SUnitTest class
	instanceVariableNames: ''!

TestCase subclass: #ExampleSetTest
	instanceVariableNames: 'full empty '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SUnitTests'!

ExampleSetTest class
	instanceVariableNames: ''!

!SUnitClientTest methodsFor: 'Private'!

isLogging
	^false!

error
        3 zork!

fail
        self assert: false!

noop!

setRun
	hasRun := true!

okTest

        self assert: true.
        ^self!

regularTestFailureTest

        self assert: false description: 'You should see me'.
        ^self!

resumableTestFailureTest
        self
                assert: false
                description: 'You should see me'
                resumable: true;
                assert: false
                description: 'You should see me too'
                resumable: true;
                assert: false
                description: 'You should see me last'
                resumable: false;
                assert: false
                description: 'You should not see me'
                resumable: true.
        ^self!

errorTest

        1 zork.
        ^self! !

!SUnitClientTest methodsFor: 'Accessing'!

hasRun
	^hasRun!

hasSetup
	^hasSetup! !

!SUnitClientTest methodsFor: 'Running'!

setUp
	hasSetup := true! !


!SUnitTest methodsFor: 'Testing'!

testAssert
	self assert: true.
	self deny: false!

testDefects
	| result suite error failure |
	suite := TestSuite new.
	suite addTest: (error := SUnitClientTest selector: #error).
	suite addTest: (failure := SUnitClientTest selector: #fail).
	result := suite run.
	self should: [(result defects includes: error) and: [
		      result defects includes: failure ]].
		      
	self
		assert: result runCount = 2;
		assert: result passedCount = 0;
		assert: result failureCount = 1;
		assert: result errorCount = 1!

testDialectLocalizedException
	self should: [TestResult signalFailureWith: 'Foo'] raise: TestResult failure.
	self should: [TestResult signalErrorWith: 'Foo'] raise: TestResult error.
	self shouldnt: [TestResult signalErrorWith: 'Foo'] raise: TestResult failure.!

testError
        | case result |
        case := SUnitClientTest selector: #error.
        result := case run.
        self
		assert: result runCount = 1;
		assert: result passedCount = 0;
		assert: result failureCount = 0;
		assert: result errorCount = 1!

testFail
        | case result |
        case := SUnitClientTest selector: #fail.
        result := case run.
	self
		assert: result runCount = 1;
		assert: result passedCount = 0;
		assert: result failureCount = 1;
		assert: result errorCount = 0!

testException
	self should: [self error: 'foo'] raise: TestResult error!

testRan
        | case |
        case := SUnitClientTest selector: #setRun.
        self assert: case hasSetup ~= true.
        case run.
        self assert: case hasSetup == true.
        self assert: case hasRun == true!

testRanOnlyOnce
        self assert: hasRun ~= true.
        hasRun := true!

testResult
	| case result |
	case := SUnitClientTest selector: #noop.
	result := case run.
	self
		assert: result runCount = 1;
		assert: result passedCount = 1;
		assert: result failureCount = 0;
		assert: result errorCount = 0!

testResumable
        | result suite |
        (suite := TestSuite new) addTest: (SUnitClientTest selector: #errorTest).
        suite addTest: (SUnitClientTest selector: #regularTestFailureTest).
        suite addTest: (SUnitClientTest selector: #resumableTestFailureTest).
        suite addTest: (SUnitClientTest selector: #okTest).
        result := suite run.
        self
		assert: result failures size = 2;
		assert: result errors size = 1!


testShould
	self should: [true].
	self shouldnt: [false]!

testSuite
	| suite result |
	suite := TestSuite new.
	suite addTest: (SUnitClientTest selector: #noop).
	suite addTest: (SUnitClientTest selector: #fail).
	suite addTest: (SUnitClientTest selector: #error).
	result := suite run.
	self
		assert: result runCount = 3;
		assert: result passedCount = 1;
		assert: result failureCount = 1;
		assert: result errorCount = 1! !

!SUnitTest class methodsFor: 'Testing'!

shouldInheritSelectors
	"answer true to inherit selectors from superclasses"

	^false! !

!ExampleSetTest methodsFor: 'Testing'!

testAdd
	empty add: 5.
	self assert: (empty includes: 5)!

testGrow
	empty addAll: (1 to: 100).
	self assert: empty size = 100!

testIllegal
	self 
		should: [empty at: 5] 
		raise: TestResult error.
	self 
		should: [empty at: 5 put: #abc] 
		raise: TestResult error!

testIncludes
	self assert: (full includes: 5).
	self assert: (full includes: #abc)!

testOccurrences
	self assert: (empty occurrencesOf: 0) = 0.
	self assert: (full occurrencesOf: 5) = 1.
	full add: 5.
	self assert: (full occurrencesOf: 5) = 1!

testRemove
	full remove: 5.
	self assert: (full includes: #abc).
	self deny: (full includes: 5)! !

!ExampleSetTest methodsFor: 'Running'!

setUp
	empty := Set new.
	full := Set with: 5 with: #abc! !


SUnitTest buildSuite run printNl!
